/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jaxws;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;
import org.eclipse.scada.utils.osgi.exporter.AbstractExporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointExporter
extends AbstractExporter {
    private static final Logger logger = LoggerFactory.getLogger(EndpointExporter.class);
    private final String baseAddress;
    private final Map<ServiceReference<?>, Endpoint> endpoints = new HashMap();

    public EndpointExporter(BundleContext context, String baseAddress) throws InvalidSyntaxException {
        super(context);
        this.baseAddress = baseAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<Endpoint> endpoints;
        super.dispose();
        EndpointExporter endpointExporter = this;
        synchronized (endpointExporter) {
            endpoints = new ArrayList<Endpoint>(this.endpoints.values());
            this.endpoints.clear();
        }
        for (Endpoint e : endpoints) {
            e.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unexportService(ServiceReference<?> serviceReference) {
        Endpoint e;
        EndpointExporter endpointExporter = this;
        synchronized (endpointExporter) {
            e = this.endpoints.remove(serviceReference);
        }
        if (e != null && e.isPublished()) {
            try {
                e.stop();
            }
            catch (Exception ex) {
                logger.warn("Failed to stop export", (Throwable)ex);
            }
        }
    }

    protected void exportService(ServiceReference<?> reference, Object service) {
        logger.info("Exporting service: {} -> {}", new Object[]{reference});
        Endpoint e = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                String[] clazzes;
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                String[] stringArray = clazzes = (String[])reference.getProperty("objectClass");
                int n = clazzes.length;
                int n2 = 0;
                while (n2 < n) {
                    String clazzName = stringArray[n2];
                    Class clazz = reference.getBundle().loadClass(clazzName);
                    WebService webService = clazz.getAnnotation(WebService.class);
                    if (webService != null) {
                        e = Endpoint.create((Object)service);
                        String address = this.makeAddress(reference, service, webService);
                        e.publish(address);
                        e = this.endpoints.put(reference, e);
                        if (e != null) {
                            try {
                                e.stop();
                            }
                            catch (Throwable e2) {
                                logger.warn("Failed to stop previous export", e2);
                            }
                            e = null;
                        }
                    } else {
                        logger.warn("No webservice annotation found on {}", (Object)clazz);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                logger.warn("Failed to export", (Throwable)ex);
                Thread.currentThread().setContextClassLoader(currentClassLoader);
                if (e != null) {
                    e.stop();
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
            if (e != null) {
                e.stop();
            }
        }
    }

    private String makeAddress(ServiceReference<?> reference, Object service, WebService webService) {
        String serviceName = webService.serviceName();
        if (serviceName == null && reference.getProperty("service.pid") != null) {
            serviceName = reference.getProperty("service.pid").toString();
        }
        return String.valueOf(this.baseAddress) + "/" + serviceName;
    }
}

