/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.pool;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPool;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.internal.UnmodifyableDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectPoolImpl<S>
implements ObjectPool<S>,
ManageableObjectPool<S> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPoolImpl.class);
    private final Multimap<String, ObjectPoolListener<S>> idListeners = HashMultimap.create();
    private final Set<ObjectPoolListener<S>> anyListener = new HashSet<ObjectPoolListener<S>>(1);
    private final Map<String, Map<S, Dictionary<?, ?>>> services = new HashMap(1);
    private final ExecutorService executor;
    private static final Dictionary<?, ?> emptyHashtable = new UnmodifyableDictionary(new Hashtable(1));
    private boolean disposed;

    public ObjectPoolImpl() {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(this.toString()));
    }

    public ObjectPoolImpl(String name) {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(name));
    }

    @Override
    public synchronized void addService(String id, S service, Dictionary<?, ?> properties) {
        Dictionary<?, ?> oldService;
        if (this.disposed) {
            return;
        }
        properties = properties == null || properties.isEmpty() ? emptyHashtable : new UnmodifyableDictionary(properties);
        logger.debug("Adding service: {} -> {} -> {}", new Object[]{id, service, properties});
        Map<S, Dictionary<?, ?>> serviceMap = this.services.get(id);
        if (serviceMap == null) {
            serviceMap = new HashMap(1);
            this.services.put(id, serviceMap);
        }
        if ((oldService = serviceMap.put(service, properties)) != null) {
            logger.warn("Replaced service: {}", new Object[]{id});
        }
        this.fireAddedService(id, service, properties);
    }

    @Override
    public synchronized void modifyService(String id, S service, Dictionary<?, ?> properties) {
        if (this.disposed) {
            return;
        }
        logger.debug("Modifing service: {} -> {} -> {}", new Object[]{id, service, properties});
        Map<S, Dictionary<?, ?>> serviceMap = this.services.get(id);
        if (serviceMap != null) {
            serviceMap.put(service, properties);
            this.fireModifiedService(id, service, properties);
        }
    }

    @Override
    public synchronized void removeService(String id, S service) {
        if (this.disposed) {
            return;
        }
        logger.debug("Removing service: {} -> {}", (Object)id, service);
        Map<S, Dictionary<?, ?>> serviceMap = this.services.get(id);
        if (serviceMap == null) {
            return;
        }
        Dictionary<?, ?> properties = serviceMap.remove(service);
        if (properties != null) {
            if (serviceMap.isEmpty()) {
                this.services.remove(id);
            }
            this.fireRemoveService(id, service, properties);
        }
    }

    private void fireAddedService(String id, final S service, final Dictionary<?, ?> properties) {
        final Collection<ObjectPoolListener<S>> listeners = this.cloneListeners(id);
        logger.debug("Fire add service: {} ({} listeners)", (Object)id, (Object)listeners.size());
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ObjectPoolListener listener : listeners) {
                    listener.serviceAdded(service, properties);
                }
            }
        });
    }

    protected Collection<ObjectPoolListener<S>> cloneListeners(String id) {
        Collection localListeners = this.idListeners.get((Object)id);
        ArrayList<ObjectPoolListener<S>> listeners = new ArrayList<ObjectPoolListener<S>>(localListeners.size() + this.anyListener.size());
        listeners.addAll(localListeners);
        listeners.addAll(this.anyListener);
        return listeners;
    }

    private void fireModifiedService(String id, final S service, final Dictionary<?, ?> properties) {
        final Collection<ObjectPoolListener<S>> listeners = this.cloneListeners(id);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ObjectPoolListener listener : listeners) {
                    listener.serviceModified(service, properties);
                }
            }
        });
    }

    private void fireRemoveService(String id, final S service, final Dictionary<?, ?> properties) {
        final Collection<ObjectPoolListener<S>> listeners = this.cloneListeners(id);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (ObjectPoolListener listener : listeners) {
                    listener.serviceRemoved(service, properties);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ObjectPoolImpl objectPoolImpl = this;
        synchronized (objectPoolImpl) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (ObjectPoolListener listener : ObjectPoolImpl.this.anyListener) {
                        for (Map map : ObjectPoolImpl.this.services.values()) {
                            for (Map.Entry serviceEntry : map.entrySet()) {
                                listener.serviceRemoved(serviceEntry.getKey(), (Dictionary)serviceEntry.getValue());
                            }
                        }
                    }
                    for (Map.Entry entry : ObjectPoolImpl.this.idListeners.entries()) {
                        Map serviceMap = (Map)ObjectPoolImpl.this.services.get(entry.getKey());
                        if (serviceMap == null) continue;
                        for (Map.Entry serviceEntry : serviceMap.entrySet()) {
                            ((ObjectPoolListener)entry.getValue()).serviceRemoved(serviceEntry.getKey(), (Dictionary)serviceEntry.getValue());
                        }
                    }
                    ObjectPoolImpl.this.anyListener.clear();
                    ObjectPoolImpl.this.idListeners.clear();
                    ObjectPoolImpl.this.services.clear();
                }
            });
            this.disposed = true;
        }
        this.executor.shutdown();
    }

    @Override
    public synchronized void addListener(String id, final ObjectPoolListener<S> listener) {
        if (this.disposed) {
            return;
        }
        logger.debug("Adding listener for {}", (Object)id);
        if (this.idListeners.put((Object)id, listener)) {
            logger.debug("Added listener {} for {}", listener, (Object)id);
            Map<S, Dictionary<?, ?>> serviceMap = this.services.get(id);
            if (serviceMap != null) {
                final HashMap serviceMapClone = new HashMap(serviceMap);
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : serviceMapClone.entrySet()) {
                            listener.serviceAdded(entry.getKey(), (Dictionary)entry.getValue());
                        }
                    }
                });
            }
        }
    }

    @Override
    public synchronized void removeListener(String id, ObjectPoolListener<S> listener) {
        if (this.disposed) {
            return;
        }
        this.idListeners.remove((Object)id, listener);
    }

    @Override
    public synchronized void addListener(final ObjectPoolListener<S> listener) {
        if (this.disposed) {
            return;
        }
        logger.debug("Adding listener {}", listener);
        if (this.anyListener.add(listener)) {
            final ArrayList servicesClone = new ArrayList(this.services.values());
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (Map serviceMap : servicesClone) {
                        for (Map.Entry entry : serviceMap.entrySet()) {
                            listener.serviceAdded(entry.getKey(), (Dictionary)entry.getValue());
                        }
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeListener(ObjectPoolListener<S> listener) {
        if (this.disposed) {
            return;
        }
        this.anyListener.remove(listener);
    }
}

