/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.impl.visibility;

import java.util.Arrays;
import java.util.List;
import org.eclipse.scada.core.ui.connection.login.LoginSession;
import org.eclipse.scada.core.ui.connection.login.SessionListener;
import org.eclipse.scada.core.ui.connection.login.SessionManager;
import org.eclipse.scada.vi.details.swt.impl.visibility.AbstractVisibilityProvider;

public class PermissionVisibilityProviderImpl
extends AbstractVisibilityProvider
implements SessionListener {
    private final List<String> permissions;

    public PermissionVisibilityProviderImpl(String permissions) {
        this.permissions = Arrays.asList(permissions.split("[,|]"));
        SessionManager.getDefault().addListener((SessionListener)this);
    }

    protected boolean evalPermission() {
        boolean result = false;
        for (String permission : this.permissions) {
            if (permission.startsWith("!")) {
                result |= !SessionManager.getDefault().hasRole(permission.substring(1));
                continue;
            }
            result |= SessionManager.getDefault().hasRole(permission);
        }
        return result;
    }

    @Override
    public void dispose() {
        SessionManager.getDefault().removeListener((SessionListener)this);
    }

    public void sessionChanged(LoginSession session) {
        this.fireChange(this.evalPermission());
    }
}

