/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.widgets.DescriptorLabel;
import org.eclipse.scada.vi.details.swt.widgets.GenericComposite;
import org.eclipse.scada.vi.details.swt.widgets.control.ControlImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoolLEDComposite
extends GenericComposite {
    private static final Logger logger = LoggerFactory.getLogger(BoolLEDComposite.class);
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private final Label signalLabel;
    private final boolean expectedValue;
    private final boolean isAlarm;
    private final boolean isOnOff;
    private final Image imageGreen = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(BoolLEDComposite.class, (String)"icons/ledGreen.png"));
    private final Image imageRed;
    private final Image imageGray = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(BoolLEDComposite.class, (String)"icons/ledGray.png"));
    private final Image imageOn;
    private final Image imageOff;
    private final String attribute;
    private final ControlImage controlImage;

    public BoolLEDComposite(Composite parent, int style, DataItemDescriptor descriptor, String format, boolean expectedValue, boolean isAlarm, boolean isOnOff, String attribute) {
        super(parent, style, null, null);
        this.imageRed = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(BoolLEDComposite.class, (String)"icons/ledRed.png"));
        this.imageOn = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(BoolLEDComposite.class, (String)"icons/on.png"));
        this.imageOff = this.resourceManager.createImageWithDefault(ImageDescriptor.createFromFile(BoolLEDComposite.class, (String)"icons/off.png"));
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.center = true;
        layout.spacing = 3;
        this.setLayout((Layout)layout);
        this.expectedValue = expectedValue;
        this.isAlarm = isAlarm;
        this.isOnOff = isOnOff;
        this.attribute = attribute;
        this.controlImage = new ControlImage(this, this.registrationManager);
        this.controlImage.setDetailItem(descriptor.asItem());
        this.signalLabel = new Label((Composite)this, 0);
        this.signalLabel.setImage(this.imageGray);
        new DescriptorLabel(this, 0, format, descriptor);
        if (descriptor != null) {
            this.registrationManager.registerItem("value", descriptor.getItemId(), descriptor.getConnectionInformation(), false, false);
        }
        if (Boolean.getBoolean("org.eclipse.scada.developer")) {
            if (this.isAlarm) {
                this.signalLabel.setToolTipText("Red");
            } else {
                this.signalLabel.setToolTipText("Green");
            }
        }
    }

    @Override
    protected void handleDispose() {
        this.resourceManager.dispose();
        super.handleDispose();
    }

    @Override
    protected void updateState(Map<String, DataValue> values, SummaryInformation summaryInformation) {
        Variant value;
        if (this.isDisposed()) {
            logger.info("No updateView cause widget is disposed");
            return;
        }
        if (this.attribute == null) {
            try {
                value = values.get("value").getValue().getValue();
            }
            catch (NullPointerException e) {
                logger.info("could not get value", (Throwable)e);
                value = Variant.NULL;
            }
        } else {
            try {
                value = (Variant)values.get("value").getValue().getAttributes().get(this.attribute);
            }
            catch (NullPointerException e) {
                logger.info("could not get attribute", (Throwable)e);
                value = Variant.NULL;
            }
        }
        if (value == null) {
            return;
        }
        if (this.isOnOff) {
            if (value.asBoolean()) {
                this.signalLabel.setImage(this.imageOn);
            } else {
                this.signalLabel.setImage(this.imageOff);
            }
        } else if (value.asBoolean() == this.expectedValue) {
            this.signalLabel.setImage(this.imageGray);
        } else if (this.isAlarm) {
            this.signalLabel.setImage(this.imageRed);
        } else {
            this.signalLabel.setImage(this.imageGreen);
        }
    }
}

