/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.vi.details.swt.widgets;

import java.util.Collection;
import java.util.Map;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.ui.DisplayCallbackHandler;
import org.eclipse.scada.vi.data.DataValue;
import org.eclipse.scada.vi.data.RegistrationManager;
import org.eclipse.scada.vi.data.SummaryInformation;
import org.eclipse.scada.vi.data.SummaryProvider;
import org.eclipse.scada.vi.details.model.Registration;
import org.eclipse.scada.vi.details.swt.Activator;
import org.eclipse.scada.vi.details.swt.data.DataItemDescriptor;
import org.eclipse.scada.vi.details.swt.impl.DetailComponentImpl;
import org.eclipse.scada.vi.details.swt.widgets.RegistrationManagerSummaryProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class GenericComposite
extends Composite
implements RegistrationManager.Listener {
    protected final RegistrationManager registrationManager;
    private final RegistrationManagerSummaryProvider summaryProvider;
    protected final CallbackHandler callbackHandler;

    public GenericComposite(Composite parent, int style, Collection<Registration> registrations, Map<String, String> properties) {
        super(parent, style);
        this.callbackHandler = new DisplayCallbackHandler(parent.getShell(), "Operation", "Confirmation required");
        this.registrationManager = new RegistrationManager(Activator.getDefault().getBundle().getBundleContext());
        this.registrationManager.addListener((RegistrationManager.Listener)this);
        this.summaryProvider = new RegistrationManagerSummaryProvider(this.registrationManager);
        if (registrations != null) {
            for (Registration reg : registrations) {
                DataItemDescriptor descriptor = DataItemDescriptor.create(DetailComponentImpl.resolve(reg.getDescriptor(), properties));
                this.registrationManager.registerItem(reg.getKey(), descriptor.getItemId(), descriptor.getConnectionInformation(), reg.isAggregateState(), true);
            }
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GenericComposite.this.handleDispose();
            }
        });
    }

    public void start() {
        this.registrationManager.open();
        this.summaryProvider.open();
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof GenericComposite) {
                ((GenericComposite)control).start();
            }
            ++n2;
        }
    }

    public void stop() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof GenericComposite) {
                ((GenericComposite)control).stop();
            }
            ++n2;
        }
        this.registrationManager.close();
        this.summaryProvider.close();
    }

    protected void handleDispose() {
        this.summaryProvider.dispose();
        this.registrationManager.dispose();
    }

    public SummaryProvider getSummaryProvider() {
        return this.summaryProvider;
    }

    public void dispose() {
        this.handleDispose();
        super.dispose();
    }

    public void triggerDataUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Display.getCurrent().isDisposed()) {
                    return;
                }
                GenericComposite.this.processUpdate();
            }
        });
    }

    private void processUpdate() {
        Map data = this.registrationManager.getData();
        SummaryInformation summaryInformation = new SummaryInformation(data);
        this.updateState(data, summaryInformation);
    }

    protected abstract void updateState(Map<String, DataValue> var1, SummaryInformation var2);
}

