/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.common;

import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.monitor.common.State;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.utils.lang.Immutable;

@Immutable
public class StateInformation {
    private final State state;
    private final Severity severity;
    private final Long lastChangeTimestamp;
    private final Long lastValueTimestamp;
    private final Long lastFailTimestamp;
    private final Long lastAckRequiredTimestamp;
    private final Long lastAckTimestamp;
    private final String lastAckUser;
    private final Variant value;
    private final Variant lastFailValue;

    public StateInformation(State state, Severity severity, Long lastChangeTimestamp, Variant value, Long lastValueTimestamp, Long lastFailTimestamp, Long lastAckRequiredTimestamp, Long lastAckTimestamp, String lastAckUser, Variant lastFailValue) {
        this.state = state;
        this.severity = severity;
        this.lastChangeTimestamp = lastChangeTimestamp;
        this.value = value;
        this.lastValueTimestamp = lastValueTimestamp;
        this.lastFailTimestamp = lastFailTimestamp;
        this.lastAckRequiredTimestamp = lastAckRequiredTimestamp;
        this.lastAckTimestamp = lastAckTimestamp;
        this.lastAckUser = lastAckUser;
        this.lastFailValue = lastFailValue;
    }

    public String toString() {
        return String.format("[%s: %s]", new Object[]{this.state, this.severity});
    }

    public State getState() {
        return this.state;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Long getLastChangeTimestamp() {
        return this.lastChangeTimestamp;
    }

    public Variant getValue() {
        return this.value;
    }

    public Long getLastValueTimestamp() {
        return this.lastValueTimestamp;
    }

    public Long getLastFailTimestamp() {
        return this.lastFailTimestamp;
    }

    public Long getLastAckRequiredTimestamp() {
        return this.lastAckRequiredTimestamp;
    }

    public Long getLastAckTimestamp() {
        return this.lastAckTimestamp;
    }

    public String getLastAckUser() {
        return this.lastAckUser;
    }

    public Variant getLastFailValue() {
        return this.lastFailValue;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.lastAckRequiredTimestamp == null ? 0 : this.lastAckRequiredTimestamp.hashCode());
        result = 31 * result + (this.lastAckTimestamp == null ? 0 : this.lastAckTimestamp.hashCode());
        result = 31 * result + (this.lastAckUser == null ? 0 : this.lastAckUser.hashCode());
        result = 31 * result + (this.lastChangeTimestamp == null ? 0 : this.lastChangeTimestamp.hashCode());
        result = 31 * result + (this.lastFailTimestamp == null ? 0 : this.lastFailTimestamp.hashCode());
        result = 31 * result + (this.lastValueTimestamp == null ? 0 : this.lastValueTimestamp.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateInformation other = (StateInformation)obj;
        if (this.lastAckRequiredTimestamp == null ? other.lastAckRequiredTimestamp != null : !this.lastAckRequiredTimestamp.equals(other.lastAckRequiredTimestamp)) {
            return false;
        }
        if (this.lastAckTimestamp == null ? other.lastAckTimestamp != null : !this.lastAckTimestamp.equals(other.lastAckTimestamp)) {
            return false;
        }
        if (this.lastAckUser == null ? other.lastAckUser != null : !this.lastAckUser.equals(other.lastAckUser)) {
            return false;
        }
        if (this.lastChangeTimestamp == null ? other.lastChangeTimestamp != null : !this.lastChangeTimestamp.equals(other.lastChangeTimestamp)) {
            return false;
        }
        if (this.lastFailTimestamp == null ? other.lastFailTimestamp != null : !this.lastFailTimestamp.equals(other.lastFailTimestamp)) {
            return false;
        }
        if (this.lastValueTimestamp == null ? other.lastValueTimestamp != null : !this.lastValueTimestamp.equals(other.lastValueTimestamp)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public static class Builder {
        private State state;
        private Severity severity;
        private Long lastChangeTimestamp;
        private Variant value;
        private Long lastValueTimestamp;
        private Long lastFailTimestamp;
        private Long lastAckRequiredTimestamp;
        private Long lastAckTimestamp;
        private String lastAckUser;
        private Variant lastFailValue;

        public Builder(StateInformation other) {
            this.state = other.state;
            this.severity = other.severity;
            this.lastChangeTimestamp = other.lastChangeTimestamp;
            this.value = other.value;
            this.lastValueTimestamp = other.lastValueTimestamp;
            this.lastFailTimestamp = other.lastFailTimestamp;
            this.lastAckRequiredTimestamp = other.lastAckRequiredTimestamp;
            this.lastAckTimestamp = other.lastAckTimestamp;
            this.lastAckUser = other.lastAckUser;
            this.lastFailValue = other.lastFailValue;
        }

        public StateInformation build() {
            return new StateInformation(this.state, this.severity, this.lastChangeTimestamp, this.value, this.lastValueTimestamp, this.lastFailTimestamp, this.lastAckRequiredTimestamp, this.lastAckTimestamp, this.lastAckUser, this.lastFailValue);
        }

        public Builder setLastAckRequiredTimestamp(Long lastAckRequiredTimestamp) {
            this.lastAckRequiredTimestamp = lastAckRequiredTimestamp;
            return this;
        }

        public Builder setLastFailTimestamp(Long lastFailTimestamp) {
            this.lastFailTimestamp = lastFailTimestamp;
            return this;
        }

        public Builder setLastValueTimestamp(Long lastValueTimestamp) {
            this.lastValueTimestamp = lastValueTimestamp;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setState(State state) {
            this.state = state;
            return this;
        }

        public Builder setLastAckTimestamp(Long lastAckTimestamp) {
            this.lastAckTimestamp = lastAckTimestamp;
            return this;
        }

        public Builder setLastChangeTimestamp(Long lastChangeTimestamp) {
            this.lastChangeTimestamp = lastChangeTimestamp;
            return this;
        }

        public Builder setLastAckUser(String lastAckUser) {
            this.lastAckUser = lastAckUser;
            return this;
        }

        public Builder setValue(Variant value) {
            this.value = value;
            return this;
        }

        public Builder setLastFailValue(Variant lastFailValue) {
            this.lastFailValue = lastFailValue;
            return this;
        }
    }
}

