/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.akn.proxy;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.eclipse.scada.ae.connection.provider.ConnectionService;
import org.eclipse.scada.ae.server.common.akn.AknHandler;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.core.server.OperationParametersHelper;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyAknService
implements AknHandler,
ConfigurationFactory {
    private static final Logger logger = LoggerFactory.getLogger(ProxyAknService.class);
    public static final String FACTORY_ID = "org.eclipse.scada.ae.server.akn.proxy";
    private final List<Entry> entries = new LinkedList<Entry>();
    private final BundleContext context;
    private final Lock readLock;
    private final Lock writeLock;

    public ProxyAknService(BundleContext context) {
        this.context = context;
        ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
        this.readLock = rw.readLock();
        this.writeLock = rw.writeLock();
    }

    public void update(UserInformation userInformation, String configurationId, Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        Entry entry = new Entry(configurationId, cfg.getIntegerChecked("priority", "'priority' must be set"), Pattern.compile(cfg.getStringNonEmpty("pattern")), cfg.getBoolean("authorative", true), cfg.getStringNonEmpty("connection.id"));
        this.writeLock.lock();
        try {
            this.delete(userInformation, configurationId);
            this.entries.add(entry);
            Collections.sort(this.entries, EntryPriorityComparator.INSTANCE);
            logger.info("{} entries in processing table", (Object)this.entries.size());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void delete(UserInformation userInformation, String configurationId) throws Exception {
        this.writeLock.lock();
        try {
            Iterator<Entry> i = this.entries.iterator();
            while (i.hasNext()) {
                if (!i.next().id.equals(configurationId)) continue;
                i.remove();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean acknowledge(String monitorId, OperationParameters operationParameters, Date aknTimestamp) {
        logger.info("acknowledge - monitorId: {}, operationParameters: {}, aknTimestamp: {}", new Object[]{monitorId, operationParameters, aknTimestamp});
        int matches = 0;
        this.readLock.lock();
        try {
            for (Entry entry : this.entries) {
                logger.debug("Checking entry: {}", (Object)entry);
                if (!entry.pattern.matcher(monitorId).matches()) continue;
                ++matches;
                this.akn(entry.connectionId, monitorId, operationParameters, aknTimestamp);
                if (!entry.authorative) continue;
                logger.debug("Entry is authorative");
                break;
            }
            boolean bl = matches > 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void akn(String connectionId, String monitorId, OperationParameters operationParameters, Date aknTimestamp) {
        logger.info("passing on acknowledge - connectionid: {}, monitorId: {}, operationParameters: {}, aknTimestamp: {}", new Object[]{connectionId, monitorId, operationParameters, aknTimestamp});
        ConnectionIdTracker tracker = new ConnectionIdTracker(this.context, connectionId, null, ConnectionService.class);
        tracker.open();
        try {
            try {
                ConnectionService connection = (ConnectionService)tracker.waitForService(1000L);
                connection.getConnection().acknowledge(monitorId, aknTimestamp, OperationParametersHelper.toData((OperationParameters)operationParameters), this.getHandler(operationParameters));
            }
            catch (InterruptedException e) {
                logger.warn("Failed to wait for connection: " + connectionId, (Throwable)e);
                tracker.close();
            }
        }
        finally {
            tracker.close();
        }
    }

    private CallbackHandler getHandler(OperationParameters operationParameters) {
        return operationParameters == null ? null : operationParameters.getCallbackHandler();
    }

    private static class Entry {
        private final Pattern pattern;
        private final boolean authorative;
        private final String connectionId;
        private final String id;
        private final int priority;

        public Entry(String id, int priority, Pattern pattern, boolean authorative, String connectionId) {
            this.id = id;
            this.priority = priority;
            this.pattern = pattern;
            this.authorative = authorative;
            this.connectionId = connectionId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        public String toString() {
            return String.format("[%s: %s, %s, %s -> %s]", this.id, this.pattern, this.authorative, this.priority, this.connectionId);
        }
    }

    private static final class EntryPriorityComparator
    implements Comparator<Entry> {
        public static final EntryPriorityComparator INSTANCE = new EntryPriorityComparator();

        private EntryPriorityComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return Integer.valueOf(o1.priority).compareTo(o2.priority);
        }
    }
}

