/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.monitor.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.ae.server.common.monitor.internal.BundleMonitorQuery;
import org.eclipse.scada.ae.server.common.monitor.internal.QueryServiceFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private BundleContext context;
    private BundleMonitorQuery allQuery;
    private ServiceRegistration<MonitorQuery> handle;
    private ObjectPoolTracker<MonitorService> poolTracker;
    private QueryServiceFactory factory;
    private ServiceRegistration<ConfigurationFactory> factoryHandle;
    private ExecutorService executor;

    public void start(BundleContext context) throws Exception {
        logger.info("Starting bundle");
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.context = context;
        this.poolTracker = new ObjectPoolTracker(context, MonitorService.class);
        this.poolTracker.open();
        this.allQuery = new BundleMonitorQuery(this.executor, context, this.poolTracker);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("service.pid", String.valueOf(context.getBundle().getSymbolicName()) + ".all");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A monitor query containing all monitor services");
        this.handle = this.context.registerService(MonitorQuery.class, (Object)this.allQuery, properties);
        this.factory = new QueryServiceFactory(this.executor, context, this.poolTracker);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("service.description", "A monitor query");
        ((Dictionary)properties).put("factoryId", "ae.monitor.query");
        this.factoryHandle = context.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
        logger.info("Initialized");
    }

    public void stop(BundleContext context) throws Exception {
        this.factoryHandle.unregister();
        this.factory.dispose();
        this.factory = null;
        this.poolTracker.close();
        this.allQuery.dispose();
        this.handle.unregister();
        this.executor.shutdown();
    }
}

