/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.event.proxy;

import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.server.event.proxy.ProxyEventQueryFactory;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private ExecutorService executor;
    private ProxyEventQueryFactory factory;
    private ServiceRegistration<ConfigurationFactory> handle;

    public void start(BundleContext context) throws Exception {
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory(context.getBundle().getSymbolicName()));
        this.factory = new ProxyEventQueryFactory(context, this.executor);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.description", "Eclipse SCADA Proxy Event Query");
        properties.put("service.vendor", "Eclipse SCADA Project");
        properties.put("factoryId", "org.eclipse.scada.ae.server.event.proxy");
        this.handle = context.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.handle.unregister();
        this.factory.dispose();
        this.executor.shutdown();
    }
}

