/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import com.google.common.collect.Interner;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.jdbc.AbstractJdbcStorageDao;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageDao
extends AbstractJdbcStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorageDao.class);
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.ae.server.storage.jdbc/CleanupThread"));

    public JdbcStorageDao(DataSourceFactory dataSourceFactory, Properties properties, boolean usePool, Interner<String> stringInterner) throws SQLException {
        super(dataSourceFactory, properties, usePool, stringInterner);
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JdbcStorageDao.this.cleanupArchive();
            }
        }, JdbcStorageDao.getCleanupPeriod(), JdbcStorageDao.getCleanupPeriod(), TimeUnit.SECONDS);
    }

    @Override
    public void dispose() {
        logger.info("Shutting down");
        this.executor.shutdown();
        super.dispose();
        logger.info("Shutdown complete");
    }

    protected boolean isReplication() {
        return Boolean.getBoolean("org.eclipse.scada.ae.server.storage.jdbc.enableReplication");
    }

    public static long getCleanupPeriod() {
        return Long.getLong("org.eclipse.scada.ae.server.storage.jdbc.cleanupPeriodSeconds", 3600L);
    }

    @Override
    protected void performStoreEvent(Event event, ConnectionContext connectionContext) throws SQLException, Exception {
        super.performStoreEvent(event, connectionContext);
        if (this.isReplication()) {
            this.storeReplicationEvent(event, connectionContext.getConnection());
        }
    }
}

