/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.jdbc;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.jdbc.NotSupportedException;
import org.eclipse.scada.ae.server.storage.jdbc.SqlCondition;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.utils.filter.Assertion;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterAssertion;
import org.eclipse.scada.utils.filter.FilterExpression;
import org.eclipse.scada.utils.filter.Operator;
import org.eclipse.scada.utils.str.StringHelper;

public class SqlConverter {
    private static final DateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    private static final Map<String, String> fieldToColumn = new HashMap<String, String>();
    public static final List<String> fixedAttributes = Arrays.asList("id", "sourceTimestamp", "entryTimestamp");
    public static final List<String> inlinedAttributes = Arrays.asList(Event.Fields.MONITOR_TYPE.getName(), Event.Fields.EVENT_TYPE.getName(), Event.Fields.VALUE.getName(), Event.Fields.MESSAGE.getName(), Event.Fields.MESSAGE_CODE.getName(), Event.Fields.PRIORITY.getName(), Event.Fields.SOURCE.getName(), Event.Fields.ACTOR_NAME.getName(), Event.Fields.ACTOR_TYPE.getName());

    static {
        fieldToColumn.put("id", "E.ID");
        fieldToColumn.put("sourceTimestamp", "E.SOURCE_TIMESTAMP");
        fieldToColumn.put("entryTimestamp", "E.ENTRY_TIMESTAMP");
        fieldToColumn.put(Event.Fields.MONITOR_TYPE.getName(), "E.MONITOR_TYPE");
        fieldToColumn.put(Event.Fields.EVENT_TYPE.getName(), "E.EVENT_TYPE");
        fieldToColumn.put(Event.Fields.MESSAGE.getName(), "E.MESSAGE");
        fieldToColumn.put(Event.Fields.MESSAGE_CODE.getName(), "E.MESSAGE_CODE");
        fieldToColumn.put(Event.Fields.PRIORITY.getName(), "E.PRIORITY");
        fieldToColumn.put(Event.Fields.SOURCE.getName(), "E.SOURCE");
        fieldToColumn.put(Event.Fields.ACTOR_NAME.getName(), "E.ACTOR_NAME");
        fieldToColumn.put(Event.Fields.ACTOR_TYPE.getName(), "E.ACTOR_TYPE");
    }

    public static SqlCondition toSql(String schema, Filter filter) throws NotSupportedException {
        AtomicInteger j = new AtomicInteger(0);
        SqlCondition condition = new SqlCondition();
        if (!filter.isEmpty()) {
            if (filter.isExpression()) {
                SqlCondition expression = SqlConverter.toSql(schema, (FilterExpression)filter, j);
                condition.condition = String.valueOf(condition.condition) + " AND " + expression.condition;
                condition.joins.addAll(expression.joins);
                condition.joinParameters.addAll(expression.joinParameters);
                condition.parameters.addAll(expression.parameters);
            } else if (filter.isAssertion()) {
                SqlCondition assertion = SqlConverter.toSql(schema, (FilterAssertion)filter, j);
                condition.condition = String.valueOf(condition.condition) + " AND " + assertion.condition;
                condition.joins.addAll(assertion.joins);
                condition.joinParameters.addAll(assertion.joinParameters);
                condition.parameters.addAll(assertion.parameters);
            }
        }
        return condition;
    }

    private static SqlCondition toSql(String schema, FilterAssertion assertion, AtomicInteger j) throws NotSupportedException {
        SqlCondition result = null;
        if (assertion.getAssertion() == Assertion.EQUALITY) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.GREATEREQ) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), ">=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.GREATERTHAN) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), ">", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.LESSEQ) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "<=", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.LESSTHAN) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "<", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.APPROXIMATE) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "approximate", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.SUBSTRING) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "like", assertion.getValue(), j);
        } else if (assertion.getAssertion() == Assertion.PRESENCE) {
            result = SqlConverter.toSql(schema, assertion.getAttribute(), "presence", assertion.getValue(), j);
        } else {
            throw new NotSupportedException();
        }
        return result;
    }

    private static SqlCondition toSql(String schema, String attribute, String op, Object value, AtomicInteger j) {
        SqlCondition condition = new SqlCondition();
        Variant v = SqlConverter.toVariant(value);
        if (fixedAttributes.contains(attribute) || inlinedAttributes.contains(attribute)) {
            if ("value".equals(attribute)) {
                if ("approximate".equals(op)) {
                    condition.condition = String.format("soundex(E.VALUE_STRING) = soundex(?)", schema);
                    condition.parameters.add((Serializable)((Object)v.asString("")));
                } else if ("like".equals(op)) {
                    condition.condition = String.format("lower(E.VALUE_STRING) like lower(?)", schema);
                    condition.parameters.add((Serializable)((Object)v.asString("")));
                } else if ("presence".equals(op)) {
                    condition.condition = String.format("(E.VALUE_STRING IS NOT NULL OR E.VALUE_INTEGER IS NOT NULL OR E.VALUE_DOUBLE IS NOT NULL)", schema);
                } else if (v.isInteger() || v.isLong()) {
                    condition.condition = String.format("E.VALUE_INTEGER " + op + " ?", schema);
                    condition.parameters.add(v.asLong(Long.valueOf(0L)));
                } else if (v.isDouble()) {
                    condition.condition = String.format("E.VALUE_DOUBLE " + op + " ?", schema);
                    condition.parameters.add(v.asDouble(Double.valueOf(0.0)));
                } else if (v.isBoolean()) {
                    condition.condition = String.format("E.VALUE_INTEGER " + op + " ?", schema);
                    condition.parameters.add(v.asLong(Long.valueOf(0L)));
                } else if (v.isNull()) {
                    condition.condition = String.format("(E.VALUE_STRING IS NULL OR E.VALUE_INTEGER IS NULL OR E.VALUE_DOUBLE IS NULL)", schema);
                    condition.parameters.add((Serializable)((Object)attribute));
                } else {
                    condition.condition = String.format("E.VALUE_STRING " + op + " ?", schema);
                    condition.parameters.add((Serializable)((Object)v.asString("")));
                }
            } else {
                Object param = null;
                if ("sourceTimestamp".equals(attribute) || "entryTimestamp".equals(attribute)) {
                    try {
                        param = new Timestamp(isoDateFormat.parse(v.asString("")).getTime());
                    }
                    catch (ParseException e) {
                        param = e.getMessage();
                    }
                } else {
                    param = "priority".equals(attribute) ? v.asInteger(Integer.valueOf(0)) : v.asString("");
                }
                if ("approximate".equals(op) && param instanceof String) {
                    condition.condition = String.format("soundex(" + SqlConverter.getColumn(attribute) + ") = soundex(?)", schema);
                    condition.parameters.add((Serializable)((Object)v.asString("")));
                } else if ("like".equals(op)) {
                    condition.condition = v.isString() ? String.format("lower(" + SqlConverter.getColumn(attribute) + ") like lower(?)", schema) : String.format("lower('' || " + SqlConverter.getColumn(attribute) + ") like lower('' || ?)", schema);
                    condition.parameters.add((Serializable)param);
                } else if ("presence".equals(op)) {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " IS NOT NULL", schema);
                } else if (v.isInteger() || v.isLong()) {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " " + op + " ?", schema);
                    condition.parameters.add(v.asLong(Long.valueOf(0L)));
                } else if (v.isDouble()) {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " " + op + " ?", schema);
                    condition.parameters.add(v.asDouble(Double.valueOf(0.0)));
                } else if (v.isBoolean()) {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " " + op + " ?", schema);
                    condition.parameters.add(v.asLong(Long.valueOf(0L)));
                } else if (v.isNull()) {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " IS NULL)", schema);
                    condition.parameters.add((Serializable)((Object)attribute));
                } else {
                    condition.condition = String.format(String.valueOf(SqlConverter.getColumn(attribute)) + " " + op + " ?", schema);
                    condition.parameters.add((Serializable)param);
                }
            }
        } else {
            int k = j.get();
            condition.joins.add("LEFT JOIN %1$sES_AE_EVENTS_ATTR field_" + k + " ON (E.ID = field_" + k + ".ID AND field_" + k + ".KEY = ?)");
            condition.joinParameters.add(attribute);
            if ("approximate".equals(op)) {
                condition.condition = String.format(" soundex(field_" + k + ".VALUE_STRING) = soundex(?)", schema);
                condition.parameters.add((Serializable)((Object)v.asString("")));
            } else if ("like".equals(op)) {
                condition.condition = String.format(" lower(field_" + k + ".VALUE_STRING) like lower(?)", schema);
                condition.parameters.add((Serializable)((Object)v.asString("")));
            } else if ("presence".equals(op)) {
                condition.condition = String.format(" (field_" + k + ".VALUE_STRING IS NOT NULL OR field_" + k + ".VALUE_INTEGER IS NOT NULL OR field_" + k + ".VALUE_DOUBLE IS NOT NULL)", schema);
            } else if (v.isInteger() || v.isLong()) {
                condition.condition = String.format(" field_" + k + ".VALUE_INTEGER " + op + " ?", schema);
                condition.parameters.add(v.asLong(Long.valueOf(0L)));
            } else if (v.isDouble()) {
                condition.condition = String.format(" field_" + k + ".VALUE_DOUBLE " + op + " ?", schema);
                condition.parameters.add(v.asDouble(Double.valueOf(0.0)));
            } else if (v.isBoolean()) {
                condition.condition = String.format(" field_" + k + ".VALUE_INTEGER " + op + " ?", schema);
                condition.parameters.add(v.asLong(Long.valueOf(0L)));
            } else if (v.isNull()) {
                condition.condition = String.format(" (field_" + k + ".VALUE_STRING IS NULL OR field_" + k + ".VALUE_INTEGER IS NULL OR field_" + k + ".VALUE_DOUBLE IS NULL)", schema);
            } else {
                condition.condition = String.format(" field_" + k + ".VALUE_STRING " + op + " ?", schema);
                condition.parameters.add((Serializable)((Object)v.asString("")));
            }
            j.incrementAndGet();
        }
        return condition;
    }

    private static Variant toVariant(Object value) {
        if (value instanceof List) {
            value = StringHelper.join((Collection)((List)value), (String)"%").replaceAll("\\?", "_");
        }
        if (value instanceof String && ((String)value).contains("#")) {
            try {
                return VariantEditor.toVariant((String)((String)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Variant.valueOf((Object)value);
    }

    private static String getColumn(String attribute) {
        return fieldToColumn.get(attribute);
    }

    static SqlCondition toSql(String schema, FilterExpression expression, AtomicInteger j) throws NotSupportedException {
        SqlCondition result = new SqlCondition();
        result.condition = "(";
        int i = 0;
        for (Filter term : expression.getFilterSet()) {
            SqlCondition r;
            if (i > 0) {
                if (expression.getOperator() == Operator.AND) {
                    result.condition = String.valueOf(result.condition) + " AND ";
                } else if (expression.getOperator() == Operator.OR) {
                    result.condition = String.valueOf(result.condition) + " OR ";
                }
            }
            if (term.isExpression()) {
                r = SqlConverter.toSql(schema, (FilterExpression)term, j);
                result.condition = String.valueOf(result.condition) + r.condition;
                result.joins.addAll(r.joins);
                result.joinParameters.addAll(r.joinParameters);
                result.parameters.addAll(r.parameters);
            } else if (term.isAssertion()) {
                r = SqlConverter.toSql(schema, (FilterAssertion)term, j);
                result.condition = String.valueOf(result.condition) + r.condition;
                result.joins.addAll(r.joins);
                result.joinParameters.addAll(r.joinParameters);
                result.parameters.addAll(r.parameters);
            }
            ++i;
        }
        if (expression.getOperator() == Operator.NOT) {
            result.condition = "NOT " + result.condition;
        }
        result.condition = String.valueOf(result.condition) + ")";
        return result;
    }
}

