/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.ae.ui.testing.navigator.QueryBean;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractQueryViewPart
extends ViewPart {
    protected QueryBean query;
    private ISelectionListener selectionListener;

    public void dispose() {
        this.removeSelectionListener();
        super.dispose();
    }

    protected void addSelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    AbstractQueryViewPart.this.setSelection(selection);
                }
            };
            this.getViewSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.selectionListener);
        }
    }

    protected void removeSelectionListener() {
        if (this.selectionListener != null) {
            this.getViewSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
    }

    protected QueryBean getQueryFromSelection(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object o = ((IStructuredSelection)selection).getFirstElement();
        if (o instanceof QueryBean) {
            return (QueryBean)((Object)o);
        }
        return null;
    }

    protected synchronized void setSelection(ISelection selection) {
        QueryBean query = this.getQueryFromSelection(selection);
        if (query != this.query && query != null && this.isSupported(query)) {
            this.clear();
            if (query != null) {
                this.setQuery(query);
            }
        }
    }

    protected abstract boolean isSupported(QueryBean var1);

    protected abstract void clear();

    protected abstract void setQuery(QueryBean var1);
}

