/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.views.views;

import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.ui.views.model.DecoratedEvent;
import org.eclipse.scada.ae.ui.views.views.EventTableColumn;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantComparator;

class EventTableSorter
extends ViewerSorter {
    private static final VariantComparator variantComparator = new VariantComparator();
    private final EventTableColumn column;
    private final int dir;
    private static final Comparator<Event> idComparator = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            return e1.getId().compareTo(e2.getId());
        }
    };
    private static final Comparator<Event> sourceTimestampComparator = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            return e1.getSourceTimestamp().compareTo(e2.getSourceTimestamp());
        }
    };
    private static final Comparator<Event> entryTimestampComparator = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            return e1.getEntryTimestamp().compareTo(e2.getEntryTimestamp());
        }
    };
    private static final Comparator<Event> sequenceComparator = new Comparator<Event>(){

        @Override
        public int compare(Event e1, Event e2) {
            return variantComparator.compare((Variant)e1.getAttributes().get("sequence"), (Variant)e2.getAttributes().get("sequence"));
        }
    };

    public EventTableSorter(EventTableColumn column, int dir) {
        this.column = column;
        this.dir = dir;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        Event e1 = ((DecoratedEvent)o1).getEvent();
        Event e2 = ((DecoratedEvent)o2).getEvent();
        if (this.column == EventTableColumn.reservedColumnId) {
            return this.chainCompare(e1, e2, idComparator, sourceTimestampComparator, sequenceComparator, entryTimestampComparator);
        }
        if (this.column == EventTableColumn.reservedColumnSourceTimestamp) {
            return this.chainCompare(e1, e2, sourceTimestampComparator, sequenceComparator, entryTimestampComparator, idComparator);
        }
        if (this.column == EventTableColumn.reservedColumnEntryTimestamp) {
            return this.chainCompare(e1, e2, entryTimestampComparator, sourceTimestampComparator, sequenceComparator, idComparator);
        }
        return 0;
    }

    private int invert(int result) {
        return (this.dir == 1024 ? -1 : 1) * result;
    }

    private int chainCompare(Event e1, Event e2, Comparator<Event> cmp1, Comparator<Event> cmp2, Comparator<Event> cmp3, Comparator<Event> cmp4) {
        int result = cmp1.compare(e1, e2);
        if (result != 0) {
            return this.invert(result);
        }
        result = cmp2.compare(e1, e2);
        if (result != 0) {
            return this.invert(result);
        }
        result = cmp3.compare(e1, e2);
        if (result != 0) {
            return this.invert(result);
        }
        result = cmp4.compare(e1, e2);
        if (result != 0) {
            return this.invert(result);
        }
        return 0;
    }
}

