/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.ca.Configuration;
import org.eclipse.scada.ca.ConfigurationAlreadyExistsException;
import org.eclipse.scada.ca.ConfigurationEvent;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.ca.Factory;
import org.eclipse.scada.ca.FactoryEvent;
import org.eclipse.scada.ca.FactoryNotFoundException;
import org.eclipse.scada.ca.FreezableConfigurationAdministrator;
import org.eclipse.scada.ca.common.ConfigurationImpl;
import org.eclipse.scada.ca.common.ConfigurationNotFoundException;
import org.eclipse.scada.ca.common.FactoryImpl;
import org.eclipse.scada.ca.common.ListenerTracker;
import org.eclipse.scada.ca.data.ConfigurationState;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.data.FactoryState;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.concurrent.AbstractFuture;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationAdministrator
implements FreezableConfigurationAdministrator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigurationAdministrator.class);
    private final BundleContext context;
    private final ExecutorService executor;
    private final ListenerTracker listenerTracker;
    private final Map<String, FactoryImpl> factories = new HashMap<String, FactoryImpl>();
    private final Map<ServiceReference<ConfigurationFactory>, ConfigurationFactory> services = new HashMap<ServiceReference<ConfigurationFactory>, ConfigurationFactory>();
    private final ServiceTracker<ConfigurationFactory, ConfigurationFactory> serviceListener;

    public AbstractConfigurationAdministrator(BundleContext context) {
        this.context = context;
        this.executor = new ExportedExecutorService("Configuration Administrator", 1, 1, 1L, TimeUnit.MINUTES);
        this.listenerTracker = new ListenerTracker(context);
        this.serviceListener = new ServiceTracker(context, ConfigurationFactory.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationFactory, ConfigurationFactory>(){

            public void removedService(ServiceReference<ConfigurationFactory> reference, ConfigurationFactory service) {
                AbstractConfigurationAdministrator.this.removedService(reference, service);
            }

            public void modifiedService(ServiceReference<ConfigurationFactory> reference, ConfigurationFactory service) {
            }

            public ConfigurationFactory addingService(ServiceReference<ConfigurationFactory> reference) {
                return AbstractConfigurationAdministrator.this.addingService(reference);
            }
        });
    }

    public synchronized void start() throws Exception {
        this.listenerTracker.open();
        this.serviceListener.open();
    }

    public synchronized void stop() throws Exception {
        this.serviceListener.close();
        this.listenerTracker.close();
    }

    public void dispose() {
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.error("Failed to stop", (Throwable)e);
        }
        this.listenerTracker.dispose();
        this.executor.shutdown();
    }

    public synchronized void freeze() throws Exception {
        this.stop();
    }

    public synchronized void thaw() throws Exception {
        this.start();
    }

    protected synchronized void addStoredFactory(String factoryId, ConfigurationImpl[] configurations) {
        logger.info("Adding stored factory: {} ({})", new Object[]{factoryId, configurations.length});
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            factory = new FactoryImpl(factoryId);
            this.setFactoryState(factory, FactoryState.LOADED);
            this.factories.put(factoryId, factory);
        }
        factory.setConfigurations(configurations);
        ConfigurationFactory factoryService = factory.getConfigurationFactoryService();
        if (factoryService != null) {
            this.scheduleBind(configurations, factoryService, factory);
        }
    }

    private synchronized void setConfigurationStatus(ConfigurationImpl configuration, ConfigurationState configurationState, Throwable error) {
        configuration.setState(configurationState, error);
        this.listenerTracker.fireEvent(new ConfigurationEvent(ConfigurationEvent.Type.STATE, (Configuration)configuration, configurationState, error));
    }

    protected synchronized void setFactoryState(FactoryImpl factory, FactoryState state) {
        factory.setState(state);
        this.listenerTracker.fireEvent(new FactoryEvent(FactoryEvent.Type.STATE, (Factory)factory, state));
    }

    private synchronized void scheduleBind(final ConfigurationImpl[] configurations, final ConfigurationFactory factoryService, final FactoryImpl factory) {
        this.setFactoryState(factory, FactoryState.BINDING);
        ConfigurationImpl[] configurationImplArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationImpl cfg = configurationImplArray[n2];
            this.setConfigurationStatus(cfg, ConfigurationState.APPLYING, null);
            ++n2;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                ConfigurationImpl[] configurationImplArray = configurations;
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    ConfigurationImpl cfg = configurationImplArray[n2];
                    AbstractConfigurationAdministrator.this.applyConfiguration(null, null, factoryService, factory, cfg);
                    ++n2;
                }
                AbstractConfigurationAdministrator.this.setFactoryState(factory, FactoryState.BOUND);
            }
        });
    }

    protected synchronized void addFactoryService(String factoryId, ConfigurationFactory service, String description) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            factory = new FactoryImpl(factoryId);
            this.factories.put(factoryId, factory);
            this.setFactoryState(factory, FactoryState.BINDING);
        }
        if (factory.getService() == null) {
            factory.setDescription(description);
            factory.setService(service);
            this.scheduleBind(factory.getConfigurations(), service, factory);
        }
    }

    protected synchronized void removeFactoryService(String factoryId, ConfigurationFactory service) {
        logger.debug("Removing factory service - factoryId: {}, service: {}", (Object)factoryId, (Object)service);
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            logger.info("Factory was not set");
            return;
        }
        logger.debug("Set factory: {}, removed factory: {}", (Object)service, factory.getService());
        if (factory.getService() == service) {
            ConfigurationImpl[] configurationImplArray = factory.getConfigurations();
            int n = configurationImplArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigurationImpl configuration = configurationImplArray[n2];
                configuration.setState(ConfigurationState.AVAILABLE, null);
                ++n2;
            }
            factory.setService(null);
            this.setFactoryState(factory, FactoryState.LOADED);
        }
    }

    protected abstract void performPurge(UserInformation var1, String var2, PurgeFuture var3) throws Exception;

    protected abstract void performStoreConfiguration(UserInformation var1, String var2, String var3, Map<String, String> var4, boolean var5, ConfigurationFuture var6) throws Exception;

    protected abstract void performDeleteConfiguration(UserInformation var1, String var2, String var3, ConfigurationFuture var4) throws Exception;

    protected synchronized void changeConfiguration(final UserInformation userInformation, String factoryId, String configurationId, Map<String, String> properties, final ConfigurationFuture future) {
        ConfigurationFactory factoryService;
        logger.info("Request to change configuration: {}/{} -> {}", new Object[]{factoryId, configurationId, properties});
        final FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            logger.warn("Factory not found: {}", new Object[]{factoryId});
            if (future != null) {
                future.setError((Throwable)new FactoryNotFoundException(factoryId));
            }
            return;
        }
        ConfigurationImpl configuration = factory.getConfiguration(configurationId);
        if (configuration != null) {
            configuration.setData(properties);
            if (properties == null) {
                factory.removeConfigration(configurationId);
            }
        } else if (properties != null) {
            configuration = new ConfigurationImpl(configurationId, factoryId, properties);
            factory.addConfiguration(configuration);
        }
        if ((factoryService = factory.getConfigurationFactoryService()) != null || configuration != null) {
            final ConfigurationImpl applyConfiguration = configuration;
            this.setConfigurationStatus(configuration, ConfigurationState.APPLYING, null);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractConfigurationAdministrator.this.applyConfiguration(userInformation, future, factoryService, factory, applyConfiguration);
                }
            });
        } else {
            future.setResult(configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyConfiguration(UserInformation userInformation, ConfigurationFuture future, ConfigurationFactory factoryService, FactoryImpl factory, ConfigurationImpl configuration) {
        logger.debug("Apply configuration: {}/{} -> {}", new Object[]{factory.getId(), configuration.getId(), configuration.getData()});
        try {
            Map<String, String> properties = configuration.getData();
            if (properties != null) {
                logger.debug("Update configuration");
                factoryService.update(userInformation, configuration.getId(), properties);
            } else {
                logger.debug("Delete configuration: {}", (Object)configuration.getId());
                factoryService.delete(userInformation, configuration.getId());
            }
            AbstractConfigurationAdministrator abstractConfigurationAdministrator = this;
            synchronized (abstractConfigurationAdministrator) {
                this.setConfigurationStatus(configuration, ConfigurationState.APPLIED, null);
            }
            logger.debug("Applied configuration: {}/{} -> {}", new Object[]{factory.getId(), configuration.getId(), configuration.getData()});
        }
        catch (Throwable e) {
            logger.warn("Apply failed configuration: {}/{} -> {}", new Object[]{factory.getId(), configuration.getId(), configuration.getData()});
            logger.warn("Apply failed configuration:", e);
            AbstractConfigurationAdministrator abstractConfigurationAdministrator = this;
            synchronized (abstractConfigurationAdministrator) {
                this.setConfigurationStatus(configuration, ConfigurationState.ERROR, e);
            }
        }
        if (future != null) {
            future.setResult(configuration);
        }
    }

    public synchronized NotifyFuture<Void> purgeFactory(UserInformation userInformation, String factoryId) {
        logger.info("Request to purge: {}", (Object)factoryId);
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return new InstantErrorFuture(new FactoryNotFoundException(factoryId).fillInStackTrace());
        }
        return this.invokePurge(userInformation, factoryId);
    }

    public synchronized NotifyFuture<Configuration> createConfiguration(UserInformation userInformation, String factoryId, String configurationId, Map<String, String> properties) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return new InstantErrorFuture(new FactoryNotFoundException(factoryId).fillInStackTrace());
        }
        if (factory.getConfiguration(configurationId) != null) {
            return new InstantErrorFuture(new ConfigurationAlreadyExistsException(factoryId, configurationId).fillInStackTrace());
        }
        return this.invokeStore(userInformation, factoryId, configurationId, properties, true);
    }

    public synchronized NotifyFuture<Configuration> updateConfiguration(UserInformation userInformation, String factoryId, String configurationId, Map<String, String> properties, boolean fullSet) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return new InstantErrorFuture(new FactoryNotFoundException(factoryId).fillInStackTrace());
        }
        if (factory.getConfiguration(configurationId) == null) {
            return new InstantErrorFuture(new ConfigurationNotFoundException(factoryId, configurationId).fillInStackTrace());
        }
        return this.invokeStore(userInformation, factoryId, configurationId, properties, fullSet);
    }

    public synchronized NotifyFuture<Configuration> deleteConfiguration(UserInformation userInformation, String factoryId, String configurationId) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return new InstantErrorFuture(new FactoryNotFoundException(factoryId).fillInStackTrace());
        }
        if (factory.getConfiguration(configurationId) == null) {
            return new InstantErrorFuture(new ConfigurationNotFoundException(factoryId, configurationId).fillInStackTrace());
        }
        return this.invokeDelete(userInformation, factoryId, configurationId);
    }

    private NotifyFuture<Void> invokePurge(final UserInformation userInformation, final String factoryId) {
        final PurgeFuture future = new PurgeFuture();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractConfigurationAdministrator.this.performPurge(userInformation, factoryId, future);
                }
                catch (Throwable e) {
                    logger.warn("Failed to complete request", e);
                    future.setComplete();
                }
            }
        });
        return future;
    }

    private NotifyFuture<Configuration> invokeStore(final UserInformation userInformation, final String factoryId, final String configurationId, final Map<String, String> properties, final boolean fullSet) {
        final ConfigurationFuture future = new ConfigurationFuture();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.debug("Storing configuration - factory: {}, configuration: {}", (Object)factoryId, (Object)configurationId);
                    AbstractConfigurationAdministrator.this.performStoreConfiguration(userInformation, factoryId, configurationId, properties, fullSet, future);
                }
                catch (Throwable e) {
                    logger.debug("Failed to store configuration", e);
                    future.setError(e);
                }
            }
        });
        return future;
    }

    private NotifyFuture<Configuration> invokeDelete(final UserInformation userInformation, final String factoryId, final String configurationId) {
        final ConfigurationFuture future = new ConfigurationFuture();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.debug("Deleting configuration - factory: {}, configuration: {}", (Object)factoryId, (Object)configurationId);
                    AbstractConfigurationAdministrator.this.performDeleteConfiguration(userInformation, factoryId, configurationId, future);
                }
                catch (Throwable e) {
                    logger.debug("Failed to delete configuration", e);
                    future.setError(e);
                }
            }
        });
        return future;
    }

    public synchronized Configuration getConfiguration(String factoryId, String configurationId) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return null;
        }
        return factory.getConfiguration(configurationId);
    }

    public synchronized Configuration[] getConfigurations(String factoryId) {
        FactoryImpl factory = this.getFactory(factoryId);
        if (factory == null) {
            return null;
        }
        return factory.getConfigurations();
    }

    public synchronized FactoryImpl getFactory(String factoryId) {
        return this.factories.get(factoryId);
    }

    public synchronized FactoryImpl[] getKnownFactories() {
        return this.factories.values().toArray(new FactoryImpl[0]);
    }

    protected ConfigurationFactory addingService(ServiceReference<ConfigurationFactory> reference) {
        String factoryId = this.checkAndGetFactoryId(reference);
        String description = this.getDescription(reference);
        if (factoryId == null) {
            return null;
        }
        ConfigurationFactory service = null;
        try {
            ConfigurationFactory factory = service = (ConfigurationFactory)this.context.getService(reference);
            this.addFactoryService(factoryId, factory, description);
            this.services.put(reference, factory);
            return factory;
        }
        catch (ClassCastException classCastException) {
            if (service != null) {
                this.context.ungetService(reference);
            }
            return null;
        }
    }

    protected synchronized void removedService(ServiceReference<ConfigurationFactory> reference, ConfigurationFactory service) {
        ConfigurationFactory factoryService = this.services.remove(reference);
        if (factoryService != null) {
            this.context.ungetService(reference);
            this.removeFactoryService((String)reference.getProperty("factoryId"), factoryService);
        }
    }

    private String getDescription(ServiceReference<?> reference) {
        String description = reference.getProperty("service.description") instanceof String ? (String)reference.getProperty("service.description") : null;
        return description;
    }

    private String checkAndGetFactoryId(ServiceReference<?> reference) {
        if (!(reference.getProperty("factoryId") instanceof String)) {
            logger.warn("Found new service {} but it is missing 'factoryId' in its properties", reference);
            return null;
        }
        String factoryId = (String)reference.getProperty("factoryId");
        return factoryId;
    }

    public synchronized NotifyFuture<Void> applyDiff(UserInformation userInformation, Collection<DiffEntry> changeSet) {
        PatchFuture future = new PatchFuture();
        for (DiffEntry entry : changeSet) {
            switch (entry.getOperation()) {
                case ADD: {
                    future.addChild(this.createConfiguration(userInformation, entry.getFactoryId(), entry.getConfigurationId(), entry.getAddedOrUpdatedData()));
                    break;
                }
                case DELETE: {
                    future.addChild(this.deleteConfiguration(userInformation, entry.getFactoryId(), entry.getConfigurationId()));
                    break;
                }
                case UPDATE_SET: {
                    future.addChild(this.updateConfiguration(userInformation, entry.getFactoryId(), entry.getConfigurationId(), entry.getAddedOrUpdatedData(), true));
                    break;
                }
                case UPDATE_DIFF: {
                    future.addChild(this.updateConfiguration(userInformation, entry.getFactoryId(), entry.getConfigurationId(), this.mergeUpdateData(entry.getAddedOrUpdatedData(), entry.getRemovedData()), false));
                }
            }
        }
        future.setComplete();
        return future;
    }

    private Map<String, String> mergeUpdateData(Map<String, String> addedOrUpdatedData, Set<String> removedData) {
        if (removedData == null || removedData.isEmpty()) {
            return addedOrUpdatedData;
        }
        HashMap<String, String> result = new HashMap<String, String>(addedOrUpdatedData);
        for (String removed : removedData) {
            result.put(removed, null);
        }
        return result;
    }

    protected static class CompositeFuture<T>
    extends AbstractFuture<Void> {
        private static final Logger logger = LoggerFactory.getLogger(PurgeFuture.class);
        private final Set<NotifyFuture<T>> futures = new HashSet<NotifyFuture<T>>();
        private boolean complete = false;

        protected CompositeFuture() {
        }

        public synchronized void setComplete() {
            this.complete = true;
            this.checkComplete();
        }

        public synchronized void addChild(final NotifyFuture<T> future) {
            this.futures.add(future);
            logger.debug("Added future: {} - {} entries", new Object[]{future, this.futures.size()});
            future.addListener(new FutureListener<T>(){

                public void complete(Future<T> xfuture) {
                    CompositeFuture.this.removed(future);
                }
            });
        }

        protected synchronized void removed(NotifyFuture<T> future) {
            this.futures.remove(future);
            logger.debug("Removed future: {} - {} entries remain", new Object[]{future, this.futures.size()});
            this.checkComplete();
        }

        protected synchronized void checkComplete() {
            if (this.complete && this.futures.isEmpty()) {
                logger.debug("Apply complete state");
                super.setResult(null);
            }
        }
    }

    protected static final class ConfigurationFuture
    extends AbstractFuture<Configuration> {
        public void setError(Throwable error) {
            super.setError(error);
        }

        public void setResult(Configuration result) {
            super.setResult((Object)result);
        }
    }

    protected static class PatchFuture
    extends CompositeFuture<Configuration> {
        protected PatchFuture() {
        }
    }

    protected static class PurgeFuture
    extends CompositeFuture<Configuration> {
        protected PurgeFuture() {
        }
    }
}

