/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.arduino;

import java.util.HashMap;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.arduino.ArduinoConnection;
import org.eclipse.scada.configuration.arduino.ArduinoDriver;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.oscar.EquinoxApplicationProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;

public class ArduinoProcessor
extends EquinoxApplicationProcessor {
    private final ArduinoDriver driver;

    public ArduinoProcessor(ArduinoDriver driver) {
        super((EquinoxApplication)driver);
        this.driver = driver;
    }

    protected void processForContext(OscarContext ctx, IFolder output, IProgressMonitor monitor) throws Exception {
        for (ArduinoConnection device : this.driver.getArduinoConnections()) {
            this.createDevice(ctx, device);
        }
    }

    private void createDevice(OscarContext ctx, ArduinoConnection device) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = Names.makeName((NamedDocumentable)device);
        data.put("host", device.getEndpoint().getNode().getHostName());
        data.put("port", "" + device.getEndpoint().getPortNumber());
        ctx.addData("org.eclipse.scada.da.server.arduino.device", id, data);
    }
}

