/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.exec.generator;

import org.eclipse.scada.configuration.component.exec.ExecComponentsPackage;
import org.eclipse.scada.configuration.component.exec.ExecJob;
import org.eclipse.scada.configuration.component.exec.LoadAverage;
import org.eclipse.scada.configuration.component.exec.LoadAverageConfiguration;
import org.eclipse.scada.configuration.component.exec.generator.ExecJobGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.text.Message;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.da.exec.configuration.ConfigurationFactory;
import org.eclipse.scada.da.exec.configuration.EnvEntryType;
import org.eclipse.scada.da.exec.configuration.FieldType;
import org.eclipse.scada.da.exec.configuration.ProcessType;
import org.eclipse.scada.da.exec.configuration.QueueType;
import org.eclipse.scada.da.exec.configuration.RegExExtractorType;
import org.eclipse.scada.da.exec.configuration.RootType;
import org.eclipse.scada.da.exec.configuration.SingleCommandType;
import org.eclipse.scada.da.exec.configuration.VariantTypeType;

public class LoadAverageGenerator
extends ExecJobGenerator {
    final LoadAverage loadAverage;
    @Message(id="loadAverage.1m.description", defaultText="Load Average 1m")
    private String description1m;
    @Message(id="loadAverage.5m.description", defaultText="Load Average 5m")
    private String description5m;
    @Message(id="loadAverage.15m.description", defaultText="Load Average 15m")
    private String description15m;

    public LoadAverageGenerator(LoadAverage loadAverage) {
        super((ExecJob)loadAverage);
        this.loadAverage = loadAverage;
    }

    protected void createField(RegExExtractorType ext, String name, VariantTypeType variantType) {
        FieldType field = ConfigurationFactory.eINSTANCE.createFieldType();
        field.setName(name);
        field.setVariantType(variantType);
        ext.getField().add((Object)field);
    }

    public void generate(GenerationContext context) {
        super.generate(context);
        this.generateExecDriver();
    }

    public void createItems(ItemCreator itemCreator) {
        CreationRequest c = itemCreator.createSourceItem(this.loadAverage.getRunsOn(), this.localItem("A.loadAvg1"));
        c.localTags(new String[]{"LAVG1"}).information(this.description1m, null, null);
        c.dataType(DataType.FLOAT).customizationTags(new String[]{"input"});
        c.create();
        c = itemCreator.createSourceItem(this.loadAverage.getRunsOn(), this.localItem("A.loadAvg5"));
        c.localTags(new String[]{"LAVG5"}).information(this.description5m, null, null);
        c.dataType(DataType.FLOAT).customizationTags(new String[]{"input"});
        c.create();
        c = itemCreator.createSourceItem(this.loadAverage.getRunsOn(), this.localItem("A.loadAvg15"));
        c.localTags(new String[]{"LAVG15"}).information(this.description15m, null, null);
        c.dataType(DataType.FLOAT).customizationTags(new String[]{"input"});
        c.create();
    }

    private void generateExecDriver() {
        LoadAverageConfiguration cfg = (LoadAverageConfiguration)this.findConfiguration(LoadAverageConfiguration.class, ExecComponentsPackage.Literals.LOAD_AVERAGE_CONFIGURATION);
        RootType root = this.findRoot();
        QueueType q = ConfigurationFactory.eINSTANCE.createQueueType();
        q.setName("Q." + this.getFullLevelName());
        root.getQueue().add((Object)q);
        SingleCommandType cmd = ConfigurationFactory.eINSTANCE.createSingleCommandType();
        q.getCommand().add((Object)cmd);
        cmd.setId(this.jobName());
        cmd.setPeriod(cfg.getPeriod());
        ProcessType process = ConfigurationFactory.eINSTANCE.createProcessType();
        process.setExec("uptime");
        EnvEntryType env = ConfigurationFactory.eINSTANCE.createEnvEntryType();
        env.setName("LANG");
        env.setValue("en_US");
        process.getEnv().add((Object)env);
        RegExExtractorType ext = ConfigurationFactory.eINSTANCE.createRegExExtractorType();
        ext.setExpression(cfg.getPattern().pattern());
        ext.setName("A");
        ext.setRequireFullMatch(false);
        cmd.getExtractor().add((Object)ext);
        this.createField(ext, null, null);
        this.createField(ext, "users", VariantTypeType.INTEGER);
        this.createField(ext, "loadAvg1", VariantTypeType.DOUBLE);
        this.createField(ext, "loadAvg5", VariantTypeType.DOUBLE);
        this.createField(ext, "loadAvg15", VariantTypeType.DOUBLE);
        cmd.setProcess(process);
    }
}

