/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator.mapper;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.configuration.component.DanglingItemReference;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.MappedSourceValue;
import org.eclipse.scada.configuration.component.generator.DataComponentGenerator;
import org.eclipse.scada.configuration.component.lib.Items;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.lib.DefaultFeatures;
import org.eclipse.scada.configuration.lib.ItemCustomizer;
import org.eclipse.scada.configuration.world.osgi.DataMapper;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.ReferenceItem;

public class MappedSourceValueGenerator
extends DataComponentGenerator {
    private final MappedSourceValue mappedSourceValue;
    private final List<ReferenceItem> refs = new LinkedList<ReferenceItem>();

    public MappedSourceValueGenerator(MappedSourceValue mappedSourceValue) {
        super((DataComponent)mappedSourceValue);
        this.mappedSourceValue = mappedSourceValue;
    }

    @Override
    public void createItems(ItemCreator itemCreator) {
        DanglingItemReference source = this.mappedSourceValue.getInput().createReference();
        CreationRequest c = itemCreator.createReferenceItem((Item)source);
        c.customizationTags((Collection)this.mappedSourceValue.getCustomizationTags());
        c.localTags(new String[]{this.mappedSourceValue.getName()});
        ReferenceItem item = (ReferenceItem)c.create();
        this.refs.add(item);
    }

    @Override
    protected void finishForMaster(FinishContext context, GeneratorContext.MasterContext master) {
        super.finishForMaster(context, master);
        for (ReferenceItem item : this.refs) {
            item.setSource(Items.replaceDanglingReference((GeneratorContext)this.context, (MasterServer)master.getImplementation(), (Item)item.getSource()));
            ItemCustomizer mapperFeature = DefaultFeatures.MAPPER((DataMapper)((DataMapper)context.requestMapping((Object)this.mappedSourceValue.getMapper(), DataMapper.class)));
            mapperFeature.customize((Item)item);
        }
    }
}

