/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib;

import java.util.LinkedList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.Level;
import org.eclipse.scada.configuration.item.CustomizationPipeline;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.item.CustomizationRunner;
import org.eclipse.scada.configuration.item.Selector;
import org.eclipse.scada.configuration.item.SelectorRunner;
import org.eclipse.scada.configuration.world.osgi.Item;

public final class Components {
    private Components() {
    }

    public static void customizeItem(Component component, Item item, CustomizationRequest request) {
        LinkedList<CustomizationPipeline> pipelines = new LinkedList<CustomizationPipeline>();
        pipelines.add(component.getCustomizationPipeline());
        ComponentWorld system = null;
        Level currentLevel = component.getLevel();
        while (currentLevel != null) {
            pipelines.add(currentLevel.getCustomizationPipeline());
            if (currentLevel.getParent() == null && currentLevel.eContainer() instanceof ComponentWorld) {
                system = (ComponentWorld)currentLevel.eContainer();
            }
            currentLevel = currentLevel.getParent();
        }
        if (system != null) {
            pipelines.add(system.getDefaultCustomizationPipeline());
        }
        new CustomizationRunner(pipelines).run(item, request);
    }

    public static boolean isArchived(Component component, Item item, CustomizationRequest request) {
        LinkedList<Selector> selectors = new LinkedList<Selector>();
        selectors.add(component.getArchiveSelector());
        ComponentWorld system = null;
        Level currentLevel = component.getLevel();
        while (currentLevel != null) {
            selectors.add(currentLevel.getArchiveSelector());
            if (currentLevel.getParent() == null && currentLevel.eContainer() instanceof ComponentWorld) {
                system = (ComponentWorld)currentLevel.eContainer();
            }
            currentLevel = currentLevel.getParent();
        }
        if (system != null) {
            selectors.add(system.getDefaultArchiveSelector());
        }
        return new SelectorRunner(selectors).run(item, request, Boolean.valueOf(false));
    }
}

