/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.Container;
import org.eclipse.scada.configuration.component.ItemInterceptor;
import org.eclipse.scada.configuration.component.lib.ItemInterceptorHandler;
import org.eclipse.scada.configuration.component.lib.create.AbstractComponentItemCreator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.Helper;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.lib.Items;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.ui.databinding.AdapterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MasterItemCreatorImpl
extends AbstractComponentItemCreator {
    static final Logger logger = LoggerFactory.getLogger(MasterItemCreatorImpl.class);
    protected final GeneratorContext.MasterContext master;
    private final Container container;

    public MasterItemCreatorImpl(GeneratorContext.MasterContext master, Component component, Container container) {
        super(component);
        this.master = master;
        this.container = container;
    }

    @Override
    public CreationRequest<SourceItem> createSelfItem(String sourceName) {
        CreationRequest<SourceItem> req = this.createSourceItem(null, sourceName);
        req.addMasterListener(new MasterListener<SourceItem>(){

            @Override
            public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                Helper.setSourceConnectionFromEndpoints(item, master.getImplementation(), Locator.getSelfEndpoints((MasterServer)master.getImplementation()));
            }
        });
        return req;
    }

    @Override
    public void createMarker(IStatus status) {
    }

    @Override
    protected <T extends Item> void itemAdded(T item, CustomizationRequest customizationRequest, List<String> originalLocalTags, Set<MasterListener<T>> masterListeners) {
        Items.addItem((MasterServer)this.master.getImplementation(), item);
        for (MasterListener<T> listener : masterListeners) {
            listener.setMaster(item, this.master);
        }
        Object c = this.container;
        while (c != null) {
            this.callItemInterceptors(item, (List<ItemInterceptor>)c.getItemInterceptors(), this.master);
            c = c.eContainer() instanceof Container ? (Container)c.eContainer() : null;
        }
    }

    protected void callItemInterceptors(Item item, List<ItemInterceptor> itemInterceptors, GeneratorContext.MasterContext masterContext) {
        for (ItemInterceptor i : itemInterceptors) {
            ItemInterceptorHandler handler = (ItemInterceptorHandler)AdapterHelper.adapt((Object)i, ItemInterceptorHandler.class);
            if (handler == null) {
                throw new IllegalStateException(String.format("Interceptor '%s' does not adapt to '%s'", i.eClass().getName(), ItemInterceptorHandler.class.getName()));
            }
            handler.interceptItem(item, i, masterContext);
        }
    }
}

