/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.component.app.MasterApplicationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.lib.Items;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.WeakReferenceDataSourceItem;

public class AlarmsInformationProcessor
extends MasterApplicationProcessor {
    public AlarmsInformationProcessor() {
    }

    public AlarmsInformationProcessor(ComponentWorld system, WorldGenerator worldGenerator) {
        super(system, worldGenerator);
    }

    @Override
    protected void processContext(GeneratorContext.MasterContext masterContext, IProgressMonitor monitor) throws Exception {
        if (masterContext.getImplementation().getAeServerInformationPrefix() == null || masterContext.getImplementation().getAeServerInformationPrefix().isEmpty()) {
            return;
        }
        this.createInternalItem(masterContext, "ae.server.info.ALERT_ACTIVE", "Alert active");
        this.createInternalItem(masterContext, "ae.server.info.ALERT_DISABLED", "Alert disabled");
        this.createInternalItem(masterContext, "ae.server.info.OK", "Summarized state OK");
        this.createInternalItem(masterContext, "ae.server.info.NOT_OK", "Summarized state NOT_OK_AKN");
        this.createInternalItem(masterContext, "ae.server.info.UNSAFE", "Summarized state UNSAFE");
        this.createInternalItem(masterContext, "ae.server.info.INACTIVE", "Summarized state INACTIVE");
        this.createInternalItem(masterContext, "ae.server.info.INIT", "Summarized state INIT");
        this.createInternalItem(masterContext, "ae.server.info.NOT_OK_AKN", "Summarized state NOT_OK_AKN");
        this.createInternalItem(masterContext, "ae.server.info.NOT_OK_NOT_AKN", "Summarized state NOT_OK_NOT_AKN");
        this.createInternalItem(masterContext, "ae.server.info.NOT_AKN", "Summarized state NOT_OK_AKN");
    }

    private void createInternalItem(GeneratorContext.MasterContext masterContext, String dataSourceId, String description) {
        WeakReferenceDataSourceItem item = OsgiFactory.eINSTANCE.createWeakReferenceDataSourceItem();
        item.setDataSourceId(dataSourceId);
        item.setName(dataSourceId);
        item.setInformation(OsgiFactory.eINSTANCE.createItemInformation());
        item.getInformation().setDescription(description);
        item.getInformation().setSystem("SCADA");
        Items.addItem((MasterServer)masterContext.getImplementation(), (Item)item);
    }
}

