/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.Generator;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.GeneratorPlugin;
import org.eclipse.scada.configuration.generator.PreparationContext;
import org.eclipse.scada.configuration.generator.component.app.GenerationContextImpl;
import org.eclipse.scada.configuration.generator.component.app.GeneratorContextImpl;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorProcessor.class);
    @Inject
    private EObject content;
    @Inject
    private WorldGenerator worldGenerator;

    public GeneratorProcessor() {
    }

    public GeneratorProcessor(EObject content, WorldGenerator worldGenerator) {
        this.content = content;
        this.worldGenerator = worldGenerator;
    }

    public void setContent(EObject content) {
        this.content = content;
    }

    public void setWorldGenerator(WorldGenerator worldGenerator) {
        this.worldGenerator = worldGenerator;
    }

    public void process(IProgressMonitor monitor) {
        HashMap<Object, Set> generatorMap = new HashMap<Object, Set>();
        LinkedList generators = new LinkedList();
        TreeIterator ti = EcoreUtil.getAllContents(Collections.singleton(this.content), (boolean)true);
        while (ti.hasNext()) {
            Object source = ti.next();
            Set gens = GeneratorPlugin.createGeneratorsFor((Object)source);
            if (gens.isEmpty()) continue;
            generatorMap.put(source, gens);
            generators.addAll(gens);
        }
        HashSet<Generator> remainingGenerators = new HashSet<Generator>(generators);
        GeneratorContextImpl ctx = new GeneratorContextImpl(this.worldGenerator);
        PreparationContext pctx = new PreparationContext(){};
        LocalGenerationContextImpl gctx = new LocalGenerationContextImpl(ctx, remainingGenerators, generatorMap);
        logger.debug("Initializing {} generators", (Object)generators.size());
        for (Generator generator : generators) {
            generator.initialize((GeneratorContext)ctx);
        }
        logger.debug("Preparing {} generators", (Object)generators.size());
        for (Generator generator : generators) {
            generator.prepare(pctx);
        }
        logger.debug("Running {} generators", (Object)generators.size());
        for (Generator generator : generators) {
            this.runGenerator(remainingGenerators, gctx, generator);
        }
        logger.debug("Finishing {} generators", (Object)generators.size());
        for (Generator generator : generators) {
            generator.finish(gctx.createFinishContext());
        }
        logger.debug("Processing post triggers");
        ctx.processPostTriggers();
    }

    private void runGenerator(Set<Generator> remainingGenerators, GenerationContext gctx, Generator generator) {
        logger.debug("Running generator: {}", (Object)generator);
        boolean needRun = remainingGenerators.contains(generator);
        logger.trace("Need to run: {}", (Object)needRun);
        if (needRun) {
            remainingGenerators.remove(generator);
            generator.generate(gctx);
        }
        logger.trace("Did run");
    }

    public void runGeneratorFor(Object source, LocalGenerationContextImpl ctx, Set<Generator> remainingGenerators, Map<Object, Set<Generator>> generatorMap) {
        logger.debug("Running generators for: {}", source);
        Set<Generator> set = generatorMap.get(source);
        if (set == null) {
            logger.debug("No generators");
            return;
        }
        for (Generator generator : set) {
            this.runGenerator(remainingGenerators, ctx, generator);
        }
    }

    private class LocalGenerationContextImpl
    extends GenerationContextImpl {
        private final Set<Generator> remainingGenerators;
        private final Map<Object, Set<Generator>> generatorMap;

        private LocalGenerationContextImpl(GeneratorContext generatorContext, Set<Generator> remainingGenerators, Map<Object, Set<Generator>> generatorMap) {
            super(generatorContext);
            this.remainingGenerators = remainingGenerators;
            this.generatorMap = generatorMap;
        }

        @Override
        protected void processFor(Object source) {
            GeneratorProcessor.this.runGeneratorFor(source, this, this.remainingGenerators, this.generatorMap);
        }
    }
}

