/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.ui;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.configuration.generator.ui.AbstractFileRunner;
import org.eclipse.scada.configuration.world.World;
import org.eclipse.scada.configuration.world.lib.WorldRunner;

public class RunWorldGeneratorHandler
extends AbstractFileRunner {
    @Override
    protected void runFile(IFile file, IProgressMonitor monitor) throws Exception {
        RunWorldGeneratorHandler.run(file, monitor);
    }

    public static void run(IFile file, IProgressMonitor monitor) throws CoreException, Exception {
        monitor.beginTask("Creating world", 10);
        IContainer parent = file.getParent();
        IFolder outputContainer = parent.getFolder((IPath)new Path("output"));
        if (outputContainer.exists()) {
            monitor.setTaskName("Cleaning up");
            outputContainer.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        outputContainer.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.setTaskName("Creating output");
        new WorldRunner().processUri(URI.createURI((String)file.getLocationURI().toString()), (IContainer)outputContainer, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
        monitor.done();
    }

    public static void run(World world, IContainer parent, IProgressMonitor monitor) throws CoreException, Exception {
        monitor.beginTask("Creating world", 10);
        IFolder outputContainer = parent.getFolder((IPath)new Path("output"));
        if (outputContainer.exists()) {
            monitor.setTaskName("Cleaning up");
            outputContainer.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        outputContainer.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        RunWorldGeneratorHandler.runWithOutput(world, (IContainer)outputContainer, monitor);
        monitor.done();
    }

    public static void runWithOutput(World world, IContainer outputContainer, IProgressMonitor monitor) throws CoreException, Exception {
        monitor.setTaskName("Creating output");
        new WorldRunner().process(null, world, outputContainer, monitor);
    }
}

