/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.CommonDriver;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.PasswordCredentials;

public abstract class AbstractCommonDriverFactory<T extends org.eclipse.scada.configuration.world.CommonDriver>
implements DriverFactory {
    private final List<DriverValidator<CommonDriver>> validators = new LinkedList<DriverValidator<CommonDriver>>();

    protected abstract void configureDriver(World var1, AbstractFactoryDriver var2, T var3);

    protected abstract T createDriver();

    public AbstractCommonDriverFactory() {
        this.validators.add(new DriverValidator<CommonDriver>(){

            @Override
            public void validate(IValidationContext ctx, CommonDriver driver, Collection<IStatus> result) {
                if (Worlds.findCommonDriverPassword(driver) == null) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(driver), (int)2, (int)0, (String)"Access to the driver is not secured by a password.", (Object[])new Object[0]));
                }
                if (driver.getPortNumber() <= 0) {
                    result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, Arrays.asList(driver), (int)4, (int)1, (String)"The port number ({0}) is invalid. It must be greater then zero.", (Object[])new Object[]{driver.getPortNumber()}));
                }
            }
        });
    }

    protected void addValidator(DriverValidator<CommonDriver> validator) {
        this.validators.add(validator);
    }

    @Override
    public org.eclipse.scada.configuration.world.Driver createDriver(World world, AbstractFactoryDriver infraDriver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes) {
        T driver = this.createDriver();
        driver.setPassword((PasswordCredentials)EcoreUtil.copy((EObject)Worlds.findCommonDriverPassword((CommonDriver)infraDriver)));
        Endpoint ep = Worlds.createDaEndpoint(world.getOptions(), (Driver)infraDriver);
        driver.getEndpoints().add((Object)ep);
        this.configureDriver(world, infraDriver, driver);
        return driver;
    }

    @Override
    public IStatus validate(IValidationContext ctx, AbstractFactoryDriver driver) {
        if (!(driver instanceof CommonDriver)) {
            return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)driver, null, (String)"Driver factory of type {0} can only process driver of type {1}", (Object[])new Object[]{this.getClass().getSimpleName(), CommonDriver.class.getSimpleName()});
        }
        Collection<IStatus> problems = this.validateDriver(ctx, (CommonDriver)driver);
        if (problems.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
    }

    protected Collection<IStatus> validateDriver(IValidationContext ctx, CommonDriver driver) {
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        this.performValidation(ctx, driver, result);
        return result;
    }

    protected void performValidation(IValidationContext ctx, CommonDriver driver, Collection<IStatus> result) {
        for (DriverValidator<CommonDriver> validator : this.validators) {
            validator.validate(ctx, driver, result);
        }
    }
}

