/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;

public abstract class DeviceValidator<T extends AbstractFactoryDriver, D extends Device>
implements DriverValidator<T> {
    private final Class<D> deviceClass;

    public DeviceValidator(Class<D> deviceClass) {
        this.deviceClass = deviceClass;
    }

    @Override
    public void validate(IValidationContext ctx, T driver, Collection<IStatus> result) {
        for (Device device : driver.getDevices()) {
            if (!this.deviceClass.isAssignableFrom(device.getClass())) continue;
            this.validateDevice((Device)this.deviceClass.cast(device), ctx, result);
        }
    }

    protected abstract void validateDevice(D var1, IValidationContext var2, Collection<IStatus> var3);
}

