/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.infrastructure.CommonDriver;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.EquinoxApplication;
import org.eclipse.scada.configuration.infrastructure.EquinoxDriver;
import org.eclipse.scada.configuration.infrastructure.ExternalDriver;
import org.eclipse.scada.configuration.infrastructure.JdbcUserService;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.Options;
import org.eclipse.scada.configuration.infrastructure.SystemPropertyUserService;
import org.eclipse.scada.configuration.infrastructure.UserService;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.internal.SystemPropertiesUserServiceProcessor;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.utils.Containers;
import org.eclipse.scada.configuration.world.Credentials;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.UsernamePasswordCredentials;
import org.eclipse.scada.configuration.world.WorldFactory;
import org.eclipse.scada.configuration.world.osgi.JdbcUserServiceModule;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.PropertyEntry;

public final class Worlds {
    private Worlds() {
    }

    public static Credentials findConnectionPassword(Driver driver) {
        if (driver instanceof CommonDriver) {
            return Worlds.findCommonConnectionPassword((CommonDriver)driver);
        }
        if (driver instanceof EquinoxDriver) {
            return Worlds.findEquinoxConnectionPassword((EquinoxDriver)driver);
        }
        if (driver instanceof ExternalDriver) {
            return Worlds.findExternalConnectionPassword((ExternalDriver)driver);
        }
        return null;
    }

    protected static Credentials findEquinoxConnectionPassword(EquinoxDriver driver) {
        if (driver.getAccessCredentials() != null) {
            return driver.getAccessCredentials();
        }
        return Worlds.findDefaultAccessCredentials((Driver)driver);
    }

    protected static Credentials findCommonConnectionPassword(CommonDriver driver) {
        if (driver.getPassword() != null) {
            return driver.getPassword();
        }
        return Worlds.findDefaultAccessCredentials((Driver)driver);
    }

    protected static Credentials findDefaultAccessCredentials(Driver driver) {
        World world = (World)Containers.findContainer((EObject)driver, World.class);
        if (world == null) {
            return null;
        }
        if (world.getDefaultDriverAccessCredentials() != null) {
            return world.getDefaultCredentials();
        }
        if (driver instanceof CommonDriver) {
            return world.getDefaultDriverPassword();
        }
        return null;
    }

    protected static Credentials findExternalConnectionPassword(ExternalDriver driver) {
        if (driver.getAccessCredentials() != null) {
            return driver.getAccessCredentials();
        }
        return Worlds.findDefaultAccessCredentials((Driver)driver);
    }

    public static PasswordCredentials findCommonDriverPassword(CommonDriver driver) {
        if (driver.getPassword() != null) {
            return driver.getPassword();
        }
        World world = (World)Containers.findContainer((EObject)driver, World.class);
        if (world == null) {
            return null;
        }
        return world.getDefaultDriverPassword();
    }

    public static Credentials findInterconnectCredentials(EquinoxApplication app) {
        if (app.getLocalCredentials() != null) {
            return app.getLocalCredentials();
        }
        World world = (World)Containers.findContainer((EObject)app, World.class);
        if (world == null) {
            return null;
        }
        return world.getDefaultCredentials();
    }

    public static Credentials findConnectionCredentials(MasterImport masterImport) {
        if (masterImport.getCredentials() != null) {
            return masterImport.getCredentials();
        }
        return Worlds.findInterconnectCredentials((EquinoxApplication)masterImport.getImportedMaster());
    }

    public static Endpoint createEndpoint(int port, String name) {
        Endpoint ep = WorldFactory.eINSTANCE.createEndpoint();
        ep.setPortNumber((short)port);
        ep.setName(name);
        return ep;
    }

    public static Endpoint createDaEndpoint(Options options, Driver driver) {
        if (driver instanceof CommonDriver) {
            return Worlds.createEndpoint(((CommonDriver)driver).getPortNumber(), "CommonDriver Endpoint: " + driver.getName());
        }
        if (driver instanceof EquinoxDriver) {
            return Worlds.createEndpoint(options.getBaseDaNgpPort() + ((EquinoxDriver)driver).getInstanceNumber(), "EquinoxDriver Endpoint: " + driver.getName());
        }
        if (driver instanceof ExternalDriver) {
            return Worlds.createEndpoint(((ExternalDriver)driver).getPortNumber(), "ExternalDriver Endpoint: " + driver.getName());
        }
        throw new IllegalStateException(String.format("Unable to create DA endpoint for driver type: %s", driver.getClass().getName()));
    }

    public static void addUserService(org.eclipse.scada.configuration.world.osgi.EquinoxApplication application, UserService userService, Options options) {
        if (userService == null) {
            userService = options.getDefaultUserService();
        }
        if (userService == null) {
            return;
        }
        if (userService instanceof JdbcUserService) {
            JdbcUserServiceModule module = OsgiFactory.eINSTANCE.createJdbcUserServiceModule();
            module.getUserServices().add((Object)((org.eclipse.scada.configuration.world.osgi.JdbcUserService)EcoreUtil.copy((EObject)((JdbcUserService)userService).getImplementation())));
            application.getModules().add((Object)module);
        } else if (userService instanceof SystemPropertyUserService) {
            new SystemPropertiesUserServiceProcessor((SystemPropertyUserService)userService).process(application);
        } else {
            throw new IllegalStateException(String.format("User service type '%s' is currently unsupported", userService.getClass()));
        }
    }

    public static boolean isLocal(Node node1, Node node2) {
        return node1.getHostName().equals(node2.getHostName());
    }

    public static String makeHostname(Node from, Node to) {
        if (Worlds.isLocal(from, to)) {
            return "localhost";
        }
        return to.getHostName();
    }

    public static Collection<PropertyEntry> convertToProperties(Credentials creds) {
        LinkedList<PropertyEntry> result = new LinkedList<PropertyEntry>();
        if (creds instanceof PasswordCredentials) {
            result.add(Properties.create((String)"password", (String)((PasswordCredentials)creds).getPassword()));
        } else if (creds instanceof UsernamePasswordCredentials) {
            result.add(Properties.create((String)"user", (String)((UsernamePasswordCredentials)creds).getUsername()));
            result.add(Properties.create((String)"password", (String)((UsernamePasswordCredentials)creds).getPassword()));
        }
        return result;
    }

    public static String makeConnectionName(Driver driver) {
        return "driver." + driver.getName();
    }
}

