/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.configuration.lib.ItemCustomizer;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;

public class CustomizationRequest {
    private final LinkedList<String> localTags;
    private final Set<String> customizationTags;
    private final Item item;
    private final List<String> hierarchy;
    private final Object component;
    private final int globalizationLevel;

    public CustomizationRequest(Object component, Item item, List<String> hierarchy, List<String> localTags, Set<String> customizationTags, int globalizationLevel) {
        this.component = component;
        this.item = item;
        this.hierarchy = Collections.unmodifiableList(new ArrayList<String>(hierarchy));
        this.localTags = new LinkedList<String>(localTags);
        this.customizationTags = new HashSet<String>(customizationTags);
        this.globalizationLevel = globalizationLevel;
    }

    public int getGlobalizationLevel() {
        return this.globalizationLevel;
    }

    public Object getComponent() {
        return this.component;
    }

    private boolean isClass(String name, Class<?> clazz) {
        if (name.equals(clazz.getName())) {
            return true;
        }
        return name.equals(clazz.getSimpleName());
    }

    public boolean isComponentClass(String name) {
        if (name == null || this.component == null) {
            return false;
        }
        Class<?>[] classArray = this.component.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (this.isClass(name, clazz)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Item getItem() {
        return this.item;
    }

    public LinkedList<String> getLocalTags() {
        return this.localTags;
    }

    public boolean isLocalTags(String ... localTags) {
        return this.localTags.equals(Arrays.asList(localTags));
    }

    public boolean isLocalTag(String localTags) {
        return this.localTags.equals(Arrays.asList(localTags));
    }

    public Set<String> getCustomizationTags() {
        return this.customizationTags;
    }

    public List<String> getHierarchy() {
        return this.hierarchy;
    }

    public boolean hasTag(String tag) {
        return this.customizationTags.contains(tag);
    }

    public boolean isType(DataType ... dataTypes) {
        if (this.item.getInformation() == null) {
            return false;
        }
        if (this.item.getInformation().getDataType() == null) {
            return false;
        }
        DataType[] dataTypeArray = dataTypes;
        int n = dataTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dataType = dataTypeArray[n2];
            if (this.item.getInformation().getDataType().equals((Object)dataType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isStringType() {
        return this.isType(DataType.STRING);
    }

    public boolean isFloatType() {
        return this.isType(DataType.FLOAT);
    }

    public boolean isBooleanType() {
        return this.isType(DataType.BOOLEAN);
    }

    public boolean isInt64Type() {
        return this.isType(DataType.INT64);
    }

    public boolean isInt32Type() {
        return this.isType(DataType.INT32);
    }

    public boolean isAnalog() {
        return this.isType(DataType.INT32, DataType.INT64, DataType.FLOAT);
    }

    public boolean isDigital() {
        return this.isType(DataType.BOOLEAN);
    }

    public void addFeature(ItemCustomizer customizer) {
        customizer.customize(this.item);
    }
}

