/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.item;

import java.util.List;
import org.eclipse.scada.configuration.item.CustomizationPipeline;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizationRunner {
    private static final Logger logger = LoggerFactory.getLogger(CustomizationRunner.class);
    private final List<CustomizationPipeline> pipelines;

    public CustomizationRunner(List<CustomizationPipeline> pipelines) {
        this.pipelines = pipelines;
    }

    public void run(Item item, CustomizationRequest request) {
        logger.debug("Customizing item - item: {}, pipelines: {}", (Object)item, this.pipelines);
        for (CustomizationPipeline pipeline : this.pipelines) {
            if (pipeline == null) continue;
            logger.debug("Using pipeline: {}", (Object)pipeline);
            pipeline.customize(request);
            return;
        }
    }
}

