/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.modbus.ModbusExporter;
import org.eclipse.scada.configuration.modbus.ModbusExporterDevice;
import org.eclipse.scada.configuration.modbus.ModbusExporterItem;
import org.eclipse.scada.configuration.modbus.ModbusPackage;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.OscarProcessor;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.PropertyEntry;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;

public class ModbusExporterProcessor
implements OscarProcessor {
    private static final String BUNDLE_MODBUS_EXPORTER = "org.eclipse.scada.da.server.exporter.modbus";
    static final String DEVICE_FACTORY_ID = "org.eclipse.scada.da.server.exporter.modbus.device";

    public void process(OscarContext ctx, EquinoxApplication application, IProgressMonitor monitor) {
        try {
            Collection exporters = EcoreUtil.getObjectsByType((Collection)application.getModules(), (EClassifier)ModbusPackage.Literals.MODBUS_EXPORTER);
            for (Object exp : exporters) {
                assert (exp instanceof ModbusExporter);
                this.processExporter(ctx, application, (ModbusExporter)exp, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void processExporter(OscarContext ctx, EquinoxApplication application, ModbusExporter exporter, IProgressMonitor monitor) {
        Profile profile = Profiles.createOrGetCustomizationProfile((EquinoxApplication)application);
        Profiles.addStartBundle((Profile)profile, (String)BUNDLE_MODBUS_EXPORTER);
        profile.getInstallationUnits().add((Object)BUNDLE_MODBUS_EXPORTER);
        for (ModbusExporterDevice device : exporter.getDevices()) {
            this.validateDevice(device);
            this.processDevice(ctx, application, device, monitor);
        }
    }

    private void validateDevice(ModbusExporterDevice device) {
        Diagnostic diag = Diagnostician.INSTANCE.validate((EObject)device);
        if (diag.getSeverity() == 4) {
            String msg = "Invalid Modbus Exporter Device";
            for (Diagnostic child : diag.getChildren()) {
                if (child.getSeverity() != 4) continue;
                msg = String.valueOf(msg) + "\n" + child.getMessage();
            }
            throw new IllegalStateException(msg);
        }
    }

    private void processDevice(OscarContext ctx, EquinoxApplication application, ModbusExporterDevice device, IProgressMonitor monitor) {
        String id = String.valueOf(Integer.toString(device.getPort().getPortNumber())) + "." + Integer.toString(device.getSlaveId());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("port", Integer.toString(device.getPort().getPortNumber()));
        data.put("slaveId", Integer.toString(device.getSlaveId()));
        data.put("dataOrder", "" + device.getDataOrder());
        for (PropertyEntry property : device.getProperties()) {
            String key = "hive." + property.getKey();
            data.put(key, property.getValue());
        }
        for (ModbusExporterItem item : device.getItems()) {
            this.processItem(data, item);
        }
        ctx.addData(DEVICE_FACTORY_ID, id, data);
    }

    private void processItem(Map<String, String> data, ModbusExporterItem item) {
        String id = "item." + item.getSource().getName();
        String value = String.valueOf(Integer.toString(item.getOffset())) + ":" + item.getType().getName();
        if (item.getType().getScale() != null) {
            value = String.valueOf(value) + ":" + item.getType().getScale();
        }
        data.put(id, value.toString());
    }
}

