/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.recipe.PropertyEntry;
import org.eclipse.scada.configuration.recipe.Task;
import org.eclipse.scada.configuration.recipe.lib.ExecutableFactory;
import org.eclipse.scada.configuration.recipe.lib.Recipe;
import org.eclipse.scada.configuration.recipe.lib.internal.DefaultExecutableFactory;
import org.eclipse.scada.configuration.recipe.lib.internal.RecipeImpl;
import org.eclipse.scada.configuration.recipe.lib.internal.TaskRunner;

public class Builder {
    private final Definition rootDefinition;

    public Builder(Definition rootDefinition) {
        this.rootDefinition = rootDefinition;
    }

    public Recipe build() {
        return this.build(new DefaultExecutableFactory());
    }

    public Recipe build(ExecutableFactory factory) {
        ArrayList<Task> result = new ArrayList<Task>(this.gatherTasks());
        Collections.sort(result, new Comparator<Task>(){

            @Override
            public int compare(Task o1, Task o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        URI rootUri = this.rootDefinition.eResource().getURI();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.gatherProperties(properties);
        HashMap<String, Object> initialContent = new HashMap<String, Object>();
        initialContent.put("documentRoot", rootUri.toString());
        return new RecipeImpl(this.convert(result, factory), initialContent, properties);
    }

    protected void gatherProperties(Map<String, String> properties) {
        this.gatherProperties(this.rootDefinition, properties);
    }

    protected void gatherProperties(Definition definition, Map<String, String> properties) {
        for (Definition imported : definition.getImport()) {
            this.gatherProperties(imported, properties);
        }
        for (PropertyEntry entry : definition.getProperties()) {
            if (entry.getValue() != null) {
                properties.put(entry.getKey(), entry.getValue());
                continue;
            }
            properties.remove(entry.getKey());
        }
    }

    private List<TaskRunner> convert(List<Task> input, ExecutableFactory factory) {
        ArrayList<TaskRunner> result = new ArrayList<TaskRunner>(input.size());
        for (Task task : input) {
            result.add(new TaskRunner(task, factory));
        }
        return result;
    }

    private Set<Task> gatherTasks() {
        HashSet<Task> result = new HashSet<Task>();
        HashSet<Definition> defs = new HashSet<Definition>();
        Builder.gatherTasks(this.rootDefinition, defs, result);
        return result;
    }

    private static void gatherTasks(Definition definition, Set<Definition> defs, Set<Task> result) {
        if (defs.contains(definition)) {
            return;
        }
        defs.add(definition);
        result.addAll((Collection<Task>)definition.getTask());
        for (Definition importDef : definition.getImport()) {
            Builder.gatherTasks(importDef, defs, result);
        }
    }
}

