/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.component;

import java.net.URL;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.ui.component.Helper;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.ui.databinding.ObservableMapStyledCellLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class NameLabelProvider
extends ObservableMapStyledCellLabelProvider {
    private final ComposedAdapterFactory adapterFactory;
    private final LocalResourceManager resourceManager;

    public NameLabelProvider(Display display, IObservableSet elements) {
        super(EMFProperties.value((EStructuralFeature)InfrastructurePackage.Literals.EQUINOX_APPLICATION__NAME).observeDetail(PojoProperties.value((String)"master").observeDetail(elements)));
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    }

    public void dispose() {
        this.adapterFactory.dispose();
        super.dispose();
        this.resourceManager.dispose();
    }

    public void update(ViewerCell cell) {
        Object ele = cell.getElement();
        if (ele instanceof Helper.Master) {
            MasterServer master = ((Helper.Master)ele).getMaster();
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)master, IItemLabelProvider.class);
            cell.setText(itemLabelProvider.getText((Object)master));
            cell.setImage(this.makeImage(itemLabelProvider.getImage((Object)master)));
        } else if (ele instanceof Helper.ItemEntry) {
            Item item = ((Helper.ItemEntry)ele).getItem();
            cell.setText("" + ((Helper.ItemEntry)ele).getLocal());
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)item, IItemLabelProvider.class);
            cell.setImage(this.makeImage(itemLabelProvider.getImage((Object)item)));
        } else {
            cell.setText("" + ele);
        }
    }

    private Image makeImage(Object image) {
        if (image == null) {
            return null;
        }
        if (image instanceof URL) {
            return this.resourceManager.createImage(ImageDescriptor.createFromURL((URL)((URL)image)));
        }
        return null;
    }
}

