/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.infrastructure;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.scada.configuration.infrastructure.ApplicationConfiguration;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.lib.ExclusiveGroups;

public class ConfigurationValidation
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        if (ctx.getTarget() instanceof ApplicationConfiguration) {
            problems.addAll(this.validateExclusiveGroup(ctx, (EList<? extends EObject>)((ApplicationConfiguration)ctx.getTarget()).getConfigurations()));
            problems.addAll(this.validateExclusiveGroup(ctx, (EList<? extends EObject>)((ApplicationConfiguration)ctx.getTarget()).getModules()));
        } else if (ctx.getTarget() instanceof World) {
            problems.addAll(this.validateExclusiveGroup(ctx, (EList<? extends EObject>)((World)ctx.getTarget()).getApplicationConfigurations()));
        }
        if (problems.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        return ConstraintStatus.createMultiStatus((IValidationContext)ctx, problems);
    }

    protected List<IStatus> validateExclusiveGroup(IValidationContext ctx, EList<? extends EObject> objects) {
        Map violations = ExclusiveGroups.validate(objects);
        LinkedList<IStatus> result = new LinkedList<IStatus>();
        for (Map.Entry entry : violations.entrySet()) {
            result.add((IStatus)ConstraintStatus.createStatus((IValidationContext)ctx, (Collection)((Collection)entry.getValue()), (String)"Object belongs to an exclusive group ({0}), but actually found multiple instances for this group.", (Object[])new Object[]{entry.getKey()}));
        }
        return result;
    }
}

