/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.validation.ocl;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.ocl.ecore.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCLConstraintDescriptor
extends AbstractConstraintDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(OCLConstraintDescriptor.class);
    private final Constraint constraint;
    private final String id;
    private final String name;
    private final String namespace;
    private final int code;
    private String messagePattern;
    private ConstraintSeverity severity;

    public OCLConstraintDescriptor(String namespace, Constraint constraint, int code, ResourceBundle messages) {
        this.constraint = constraint;
        String name = constraint.getName();
        if (name == null) {
            name = Long.toHexString(System.identityHashCode(constraint));
        }
        this.id = String.valueOf(namespace) + '.' + name;
        this.name = name;
        this.namespace = namespace;
        this.code = code;
        if (messages != null) {
            this.messagePattern = this.getString(messages, String.valueOf(name) + ".message");
            String severityString = this.getString(messages, String.valueOf(name) + ".severity");
            if (severityString != null) {
                this.severity = ConstraintSeverity.valueOf((String)severityString);
            }
        }
        if (this.severity == null) {
            this.severity = ConstraintSeverity.ERROR;
        }
    }

    public String getString(ResourceBundle messages, String name) {
        try {
            return messages.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            logger.debug("Did not find: {}", (Object)name);
            return null;
        }
    }

    final Constraint getConstraint() {
        return this.constraint;
    }

    public String getBody() {
        return this.constraint.getSpecification().getBodyExpression().toString();
    }

    public String getDescription() {
        return this.getBody();
    }

    public EvaluationMode<?> getEvaluationMode() {
        return EvaluationMode.BATCH;
    }

    public String getId() {
        return this.id;
    }

    public String getMessagePattern() {
        if (this.messagePattern != null) {
            return this.messagePattern;
        }
        return String.format("Constraint %s violated on {0}", this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPluginId() {
        return this.namespace;
    }

    public ConstraintSeverity getSeverity() {
        return this.severity;
    }

    public int getStatusCode() {
        return this.code;
    }

    public boolean targetsEvent(Notification notification) {
        return false;
    }

    public boolean targetsTypeOf(EObject eObject) {
        return ((EClassifier)this.constraint.getSpecification().getContextVariable().getType()).isInstance((Object)eObject);
    }
}

