/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.DebianDeploymentMechanism;
import org.eclipse.scada.configuration.world.lib.deployment.ChangeEntryComparator;
import org.eclipse.scada.configuration.world.lib.deployment.CommonPackageHandler;
import org.eclipse.scada.configuration.world.lib.utils.Helper;
import org.eclipse.scada.configuration.world.lib.utils.ProcessRunner;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebianHandler
extends CommonPackageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DebianHandler.class);
    private final DebianDeploymentMechanism deploy;

    public DebianHandler(ApplicationNode applicationNode, DebianDeploymentMechanism deploy) {
        super(applicationNode);
        this.deploy = deploy;
    }

    @Override
    protected String getBaseFolderName() {
        return "debian-packages";
    }

    @Override
    protected void handleProcess(IFolder nodeDir, IProgressMonitor monitor, Map<String, String> properties) throws Exception {
        File packageFolder = this.getPackageFolder(nodeDir);
        String packageName = this.getPackageName();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("packageName", packageName);
        replacements.put("authorName", this.deploy.getMaintainer().getName());
        replacements.put("authorEmail", this.deploy.getMaintainer().getEmail());
        replacements.put("nodeName", this.applicationNode.getName() == null ? this.applicationNode.getHostName() : this.applicationNode.getName());
        replacements.put("postinst.restart", this.createPostInst(this.makeDriverList()));
        replacements.put("prerm.stop", this.createPreRm(this.makeDriverList()));
        replacements.put("depends", this.makeDependencies());
        replacements.put("postinst.scripts", this.createScriptFile(packageFolder, "postinst"));
        replacements.put("prerm.scripts", this.createScriptFile(packageFolder, "prerm"));
        replacements.put("postrm.scripts", this.createScriptFile(packageFolder, "postrm"));
        Helper.createFile(new File(packageFolder, "debian/source/format"), "3.0 (native)", monitor);
        Helper.createFile(new File(packageFolder, "debian/compat"), "8", monitor);
        Helper.createFile(new File(packageFolder, "debian/docs"), "", monitor);
        Helper.createFile(new File(packageFolder, "debian/" + packageName + ".install"), "src/* /", monitor);
        Helper.createFile(new File(packageFolder, "debian/postinst"), DebianHandler.class.getResourceAsStream("templates/deb/postinst"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "debian/prerm"), DebianHandler.class.getResourceAsStream("templates/deb/prerm"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "debian/postrm"), DebianHandler.class.getResourceAsStream("templates/deb/postrm"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "debian/rules"), DebianHandler.class.getResourceAsStream("templates/deb/rules"), monitor, true);
        Helper.createFile(new File(packageFolder, "debian/control"), DebianHandler.class.getResourceAsStream("templates/deb/control"), replacements, monitor);
        Helper.createFile(new File(packageFolder, "debian/changelog"), this.createChangeLog(packageName, (List<ChangeEntry>)this.deploy.getChanges()), monitor);
        this.createDrivers(nodeDir, monitor, packageFolder, replacements);
        this.createEquinox(nodeDir.getLocation().toFile(), packageFolder, replacements, monitor);
        if (!Boolean.parseBoolean(properties.get("skipRunDeployment"))) {
            monitor.setTaskName("Running \"debuild -us -uc\"");
            ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList("debuild", "-us", "-uc"));
            processBuilder.directory(packageFolder);
            try {
                new ProcessRunner(processBuilder).run();
            }
            catch (Exception e) {
                logger.warn("Failed to generate debian package", (Throwable)e);
            }
            nodeDir.refreshLocal(2, monitor);
        }
    }

    private String createScriptFile(File packageFolder, String type) {
        File dir = new File(packageFolder, "src/usr/lib/eclipsescada/packagescripts/" + this.getPackageName() + "/" + type);
        LinkedList<String> scripts = new LinkedList<String>();
        if (!dir.isDirectory()) {
            return "";
        }
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile()) {
                file.setExecutable(true);
                scripts.add("/usr/lib/eclipsescada/packagescripts/" + this.getPackageName() + "/" + type + "/" + file.getName() + " $@");
            }
            ++n2;
        }
        return StringHelper.join(scripts, (String)"\n");
    }

    @Override
    protected void processDriver(IProgressMonitor monitor, File packageFolder, Map<String, String> replacements, String driverName, File sourceDir, File driverDir) throws IOException, Exception {
        super.processDriver(monitor, packageFolder, replacements, driverName, sourceDir, driverDir);
        Helper.createFile(new File(packageFolder, "src/etc/init/scada.driver." + driverName + ".conf"), DebianHandler.class.getResourceAsStream("templates/deb/driver.upstart.conf"), replacements, monitor);
    }

    @Override
    protected void processEquinox(File sourceBase, File packageFolder, Map<String, String> replacements, IProgressMonitor monitor, String name) throws IOException, Exception, FileNotFoundException {
        super.processEquinox(sourceBase, packageFolder, replacements, monitor, name);
        Helper.createFile(new File(packageFolder, "src/etc/init/scada.app." + name + ".conf"), DebianHandler.class.getResourceAsStream("templates/deb/p2.upstart.conf"), replacements, monitor);
    }

    private String makeDependencies() {
        HashSet<String> result = new HashSet<String>();
        result.add("org.eclipse.scada");
        if (this.needP2()) {
            result.add("org.eclipse.scada.p2");
        }
        result.add("org.eclipse.scada.deploy.p2-incubation");
        result.addAll((Collection<String>)this.deploy.getAdditionalDependencies());
        return StringHelper.join(result, (String)", ");
    }

    private String createPostInst(Set<String> driverName) {
        StringBuilder sb = new StringBuilder();
        for (String driver : driverName) {
            sb.append(String.format("    restart scada.driver.%1$s || echo failed to restart %1$s", driver));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String createPreRm(Set<String> driverName) {
        StringBuilder sb = new StringBuilder();
        for (String driver : driverName) {
            sb.append(String.format("    stop scada.driver.%1$s || echo failed to restart %1$s", driver));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String createChangeLog(String packageName, List<ChangeEntry> changes) {
        StringBuilder sb = new StringBuilder();
        ArrayList<ChangeEntry> sortedChanges = new ArrayList<ChangeEntry>(changes);
        Collections.sort(sortedChanges, new ChangeEntryComparator(true));
        for (ChangeEntry entry : sortedChanges) {
            sb.append(String.format("%s (%s) stable; urgency=low\n", packageName, entry.getVersion()));
            sb.append('\n');
            sb.append(entry.getDescription());
            sb.append('\n');
            sb.append('\n');
            Throwable throwable = null;
            Object var8_9 = null;
            try (Formatter f = new Formatter(sb, Locale.ENGLISH);){
                f.format(" -- %1$s <%2$s>  %3$ta, %3$te %3$tb %3$tY %3$tT %3$tz", entry.getAuthor().getName(), entry.getAuthor().getEmail(), entry.getDate());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

