/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.deployment.wix;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.configuration.world.deployment.P2Platform;
import org.eclipse.scada.configuration.world.lib.deployment.wix.MsiPlatform;
import org.eclipse.scada.configuration.world.lib.deployment.wix.XMLBase;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.utils.str.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AntWixBuilder
extends XMLBase {
    private static final String[] DEFAULT_IUS = new String[]{"org.eclipse.equinox.launcher", "org.eclipse.osgi", "org.eclipse.equinox.common", "org.eclipse.update.configurator", "org.eclipse.equinox.ds", "org.eclipse.equinox.p2.console", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.scada.utils.osgi.autostart", "org.eclipse.equinox.console", "org.apache.felix.gogo.shell", "org.apache.felix.gogo.runtime", "org.apache.felix.gogo.command", "org.eclipse.scada.utils.osgi.daemon"};
    private final String outputFilename;
    private final MsiPlatform platform;
    private final List<Application> applications = new LinkedList<Application>();
    private final P2Platform p2Platform;
    private final Set<String> wixExtensions;
    private final boolean enableSubst;
    private final String stagingDirVar;

    public AntWixBuilder(String outputFilename, MsiPlatform platform, P2Platform p2Platform, Set<String> wixExtensions, boolean enableSubst) {
        this.outputFilename = outputFilename;
        this.platform = platform;
        this.p2Platform = p2Platform;
        this.wixExtensions = wixExtensions;
        this.enableSubst = enableSubst;
        this.stagingDirVar = enableSubst ? "staging.dir.short" : "staging.dir";
    }

    public void write(File packageFolder) throws Exception {
        Document doc = this.createXmlDocument();
        this.createDocument(doc);
        this.storeXmlDocument(doc, new File(packageFolder, "build.ant"));
    }

    private void createDocument(Document doc) throws Exception {
        Element ele = doc.createElement("project");
        doc.appendChild(ele);
        ele.setAttribute("name", "project");
        ele.setAttribute("default", "default");
        Element desc = this.createElement(ele, "description");
        desc.appendChild(doc.createTextNode(String.format("Build the Wix setup project", new Object[0])));
        Element env = this.createElement(ele, "property");
        env.setAttribute("environment", "env");
        this.createProperty(ele, "wix.root", "value", "${env.WIX}");
        this.createProperty(ele, "staging.dir", "location", "staging");
        if (this.enableSubst) {
            this.createProperty(ele, "subst.drive", "value", "K:");
            this.createProperty(ele, "staging.dir.short", "location", "${subst.drive}/staging");
        }
        this.createTarget(ele, "default", Arrays.asList("clean", "download", "unpack", "provision", "heat", "build"));
        Element clean = this.createTarget(ele, "clean");
        Element download = this.createTarget(ele, "download");
        Element unpack = this.createTarget(ele, "unpack");
        Element provision = this.createTarget(ele, "provision");
        Element heat = this.createTarget(ele, "heat");
        Element build = this.createTarget(ele, "build");
        this.fillCleanTarget(clean);
        this.fillDownloadTaret(download);
        this.fillUnpackTaret(unpack);
        this.fillProvisionTarget(provision);
        this.fillHeatTarget(heat);
        this.fillBuildTarget(build);
    }

    private void fillProvisionTarget(Element provision) throws Exception {
        for (Application app : this.applications) {
            this.appendFragment(provision, String.format("<property name=\"%1$s.dir\" location=\"staging/apps/%1$s\"/>", app.getName()));
            String dest = String.format("${%s.dir}", app.getName());
            this.appendFragment(provision, String.format("<mkdir dir=\"%s\"/>", dest));
            this.appendFragment(provision, String.format("<echo message=\"Running P2 director application. This might take some time!\"/>", new Object[0]));
            Element p2 = this.createElement(provision, "p2.director");
            p2.setAttribute("roaming", "true");
            p2.setAttribute("bundlepool", dest);
            p2.setAttribute("flavor", "tooling");
            p2.setAttribute("profile", "SDKProfile");
            p2.setAttribute("ws", "win32");
            p2.setAttribute("os", "win32");
            p2.setAttribute("arch", this.makeArch());
            p2.setAttribute("nl", "en_US");
            p2.setAttribute("destination", dest);
            StringBuilder sb = new StringBuilder();
            for (String repo : this.p2Platform.getRepositories()) {
                sb.append("-repository ");
                sb.append(repo);
                sb.append("\n");
            }
            sb.append("-profileProperties org.eclipse.update.install.features=true\n");
            p2.setAttribute("extraarguments", sb.toString());
            String[] stringArray = this.defaultIUs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String iu = stringArray[n2];
                Element ele = this.createElement(p2, "iu");
                ele.setAttribute("id", iu);
                ++n2;
            }
            for (String iu : app.getProfile().getInstallationUnits()) {
                Element ele = this.createElement(p2, "iu");
                ele.setAttribute("id", iu);
            }
            Element echo = this.createElement(provision, "echo");
            echo.setAttribute("append", "false");
            echo.setAttribute("file", String.valueOf(dest) + "/configuration/config.ini");
            sb = new StringBuilder();
            sb.append("osgi.bundles=org.eclipse.equinox.common@1:start, org.eclipse.update.configurator@2:start, org.eclipse.scada.utils.osgi.autostart@3:start\n");
            sb.append("eclipse.ignoreApp=true\n");
            sb.append("osgi.noShutdown=true\n");
            sb.append("equinox.use.ds=true\n");
            sb.append("eclipse.p2.data.area=@config.dir/../p2/\n");
            sb.append("eclipse.p2.profile=SDKProfile\n");
            sb.append("org.eclipse.scada.utils.osgi.autostart.url=$${osgi.install.area}/startLevels.properties\n");
            sb.append("org.eclipse.equinox.simpleconfigurator.configUrl=file\\:org.eclipse.equinox.simpleconfigurator/bundles.info\n");
            echo.appendChild(echo.getOwnerDocument().createCDATASection(sb.toString()));
            this.appendFragment(provision, String.format("<copy tofile=\"%1$s/osgi.jar\"><fileset dir=\"%1$s/plugins\" includes=\"org.eclipse.osgi_*.jar\" /><mapper type=\"flatten\" /></copy>", dest));
            this.appendFragment(provision, String.format("<copy tofile=\"%1$s/daemon.jar\"><fileset dir=\"%1$s/plugins\" includes=\"org.eclipse.scada.utils.osgi.daemon_*.jar\" /><mapper type=\"flatten\" /></copy>", dest));
        }
    }

    private String[] defaultIUs() {
        return DEFAULT_IUS;
    }

    private String makeArch() {
        switch (this.platform) {
            case WIN32: {
                return "x86";
            }
            case WIN64: {
                return "x86_64";
            }
        }
        throw new IllegalStateException(String.format("Unsupported platform for P2: %s", new Object[]{this.platform}));
    }

    private void fillUnpackTaret(Element unpack) throws Exception {
        this.appendFragment(unpack, "<mkdir dir=\"unpack/commons-daemon\"/>");
        this.appendFragment(unpack, "<unzip src=\"download/commons-daemon-bin-windows.zip\" dest=\"unpack/commons-daemon\"/>");
    }

    private void fillDownloadTaret(Element download) throws Exception {
        this.appendFragment(download, "<mkdir dir=\"download\"/>");
        String commonsDaemonSrc = System.getProperty("org.eclipse.scada.configuration.world.lib.deployment.wix.commonsDaemon.nativeBin.source");
        if (commonsDaemonSrc == null) {
            commonsDaemonSrc = "https://www.apache.org/dist/commons/daemon/binaries/windows/commons-daemon-1.0.15-bin-windows.zip";
        }
        this.appendFragment(download, "<get usetimestamp=\"true\" src=\"" + commonsDaemonSrc + "\" dest=\"download/commons-daemon-bin-windows.zip\"/>");
    }

    private void fillBuildTarget(Element build) {
        this.startSubst(build);
        Element candle = this.createElement(build, "exec");
        candle.setAttribute("executable", "${wix.root}/bin/candle.exe");
        if (this.enableSubst) {
            candle.setAttribute("dir", "${subst.drive}/");
        }
        candle.setAttribute("failifexecutionfails", "true");
        candle.setAttribute("failonerror", "true");
        this.addArg(candle, String.format("-dStagingDir=${%s}", this.stagingDirVar));
        this.addArg(candle, "-arch");
        this.addArg(candle, this.platform != null ? this.platform.toWixString() : MsiPlatform.WIN32.toWixString());
        for (String ext : this.wixExtensions) {
            this.addArg(candle, "-ext");
            this.addArg(candle, ext);
        }
        this.addArg(candle, "Setup.wxs");
        this.addArg(candle, "Scan.wxs");
        Element light = this.createElement(build, "exec");
        light.setAttribute("executable", "${wix.root}/bin/light.exe");
        if (this.enableSubst) {
            light.setAttribute("dir", "${subst.drive}/");
        }
        light.setAttribute("failifexecutionfails", "true");
        light.setAttribute("failonerror", "true");
        for (String ext : this.wixExtensions) {
            this.addArg(light, "-ext");
            this.addArg(light, ext);
        }
        this.addArg(light, "Setup.wixobj");
        this.addArg(light, "Scan.wixobj");
        this.addArg(light, "-out");
        this.addArg(light, this.outputFilename);
        this.stopSubst(build);
    }

    private void startSubst(Element build) {
        if (!this.enableSubst) {
            return;
        }
        Element substc = this.createElement(build, "exec");
        substc.setAttribute("executable", "subst");
        substc.setAttribute("failifexecutionfails", "false");
        substc.setAttribute("failonerror", "false");
        this.addArg(substc, "${subst.drive}");
        this.addArg(substc, ".");
    }

    private void stopSubst(Element build) {
        if (!this.enableSubst) {
            return;
        }
        Element substd = this.createElement(build, "exec");
        substd.setAttribute("executable", "subst");
        substd.setAttribute("failifexecutionfails", "false");
        substd.setAttribute("failonerror", "false");
        this.addArg(substd, "${subst.drive}");
        this.addArg(substd, "/D");
    }

    private void fillHeatTarget(Element heat) {
        this.startSubst(heat);
        Element ele = this.createElement(heat, "exec");
        ele.setAttribute("executable", "${wix.root}/bin/heat.exe");
        ele.setAttribute("dir", String.format("${%s}", this.stagingDirVar));
        ele.setAttribute("failifexecutionfails", "true");
        ele.setAttribute("failonerror", "true");
        this.addArg(ele, "dir");
        this.addArg(ele, String.format("${%s}", this.stagingDirVar));
        this.addArg(ele, "-gg");
        this.addArg(ele, "-cg");
        this.addArg(ele, "ScanComponent");
        this.addArg(ele, "-sfrag");
        this.addArg(ele, "-sreg");
        this.addArg(ele, "-scom");
        this.addArg(ele, "-suid");
        this.addArg(ele, "-srd");
        this.addArg(ele, "-dr");
        this.addArg(ele, "INSTALLDIR");
        this.addArg(ele, "-var");
        this.addArg(ele, "var.StagingDir");
        this.addArg(ele, "-out");
        if (this.enableSubst) {
            this.addArg(ele, "${subst.drive}/Scan.wxs");
        } else {
            Element arg = this.createElement(ele, "arg");
            arg.setAttribute("file", "Scan.wxs");
        }
        this.stopSubst(heat);
    }

    private void addArg(Element ele, String string) {
        Element arg = this.createElement(ele, "arg");
        arg.setAttribute("value", string);
    }

    private void fillCleanTarget(Element clean) throws Exception {
        this.appendFragment(clean, "<delete dir=\"unpack\"/>");
        this.appendFragment(clean, "<delete dir=\".\"><include name=\"*.msi\"/><include name=\"*.wixobj\"/><include name=\"Scan.wxs\"/></delete>");
    }

    private Element createTarget(Element project, String name) {
        return this.createTarget(project, name, Collections.emptyList());
    }

    private Element createTarget(Element project, String name, List<String> depends) {
        Element ele = this.createElement(project, "target");
        ele.setAttribute("name", name);
        if (!depends.isEmpty()) {
            ele.setAttribute("depends", StringHelper.join(depends, (String)","));
        }
        ele.setAttribute("unless", "skip." + name);
        return ele;
    }

    private void createProperty(Element parent, String key, String type, String value) {
        Element ele = this.createElement(parent, "property");
        ele.setAttribute("name", key);
        ele.setAttribute(type, value);
    }

    public void addApplication(Application application) {
        this.applications.add(application);
    }

    public static class Application {
        private final String name;
        private final Profile profile;

        public Application(String name, Profile profile) {
            this.name = name;
            this.profile = profile;
        }

        public String getName() {
            return this.name;
        }

        public Profile getProfile() {
            return this.profile;
        }
    }
}

