/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.utils.TypeVisitor;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.lib.oscar.BasicOscarProcessor;
import org.eclipse.scada.configuration.world.lib.oscar.Helper;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.osgi.AknProxy;
import org.eclipse.scada.configuration.world.osgi.AlarmsEventsConnection;
import org.eclipse.scada.configuration.world.osgi.AlarmsEventsModule;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.EventPool;
import org.eclipse.scada.configuration.world.osgi.EventPoolProxy;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.MonitorPool;
import org.eclipse.scada.configuration.world.osgi.MonitorPoolProxy;
import org.eclipse.scada.configuration.world.osgi.PullEvents;

public class AlarmsEventsModuleProcessor
extends BasicOscarProcessor {
    private final MasterServer app;

    public AlarmsEventsModuleProcessor(MasterServer app, OscarContext ctx) {
        super((NamedDocumentable)app, ctx);
        this.app = app;
    }

    public void process(IProgressMonitor monitor) {
        try {
            try {
                new TypeWalker(AlarmsEventsModule.class).walk((EObject)this.app, (TypeVisitor)new TypeVisitor<AlarmsEventsModule>(){

                    public void visit(AlarmsEventsModule item) throws Exception {
                        AlarmsEventsModuleProcessor.this.process(item);
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void process(AlarmsEventsModule module) {
        for (EventPoolProxy proxy : module.getEventPoolProxies()) {
            this.processEventProxy(proxy);
        }
        for (EventPoolProxy proxy : module.getMonitorPoolProxies()) {
            this.processMonitorProxy((MonitorPoolProxy)proxy);
        }
        for (EventPoolProxy proxy : module.getAknProxies()) {
            this.processAknProxy((AknProxy)proxy);
        }
        for (PullEvents pull : module.getPullEvents()) {
            this.processPullEvents(pull);
        }
    }

    private void processPullEvents(PullEvents pull) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("driverName", pull.getJdbcDriverName());
        Helper.addOptional(data, "customDeleteSql", pull.getCustomDeleteSql());
        Helper.addOptional(data, "customSelectSql", pull.getCustomSelectSql());
        data.putAll(Properties.makeAttributes((String)"jdbcProperties", (Collection)pull.getJdbcProperties()));
        Helper.addOptional(data, "delay", pull.getJobInterval());
        this.addData("org.eclipse.scada.ae.slave.pull", Names.makeName((NamedDocumentable)pull), data);
    }

    private void processAknProxy(AknProxy proxy) {
        HashMap<String, String> data = new HashMap<String, String>();
        boolean isLocal = Nodes.isLocal(proxy.getConnection().getEndpoint().getNode(), (Application)this.app);
        data.put("pattern", "" + proxy.getPattern());
        data.put("authorative", "" + proxy.isAuthorative());
        data.put("connection.id", proxy.getConnection().makeUri(isLocal));
        data.put("priority", "" + proxy.getPriority());
        this.addData("org.eclipse.scada.ae.server.akn.proxy", String.format("%s-%s", proxy.getConnection().getEndpoint().getNode().getHostName(), proxy.getPriority()), data);
    }

    private void processEventProxy(EventPoolProxy proxy) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = Names.makeName((NamedDocumentable)proxy);
        data.put("poolSize", "" + proxy.getSize());
        int i = 0;
        for (EventPool remote : proxy.getRemote()) {
            data.put("remote.queries." + i, this.makeUri(this.app, (NamedDocumentable)remote));
            ++i;
        }
        i = 0;
        for (EventPool local : proxy.getLocal()) {
            data.put("local.queries." + i, Names.makeName((NamedDocumentable)local));
            ++i;
        }
        this.addData("org.eclipse.scada.ae.server.event.proxy", id, data);
    }

    private void processMonitorProxy(MonitorPoolProxy proxy) {
        HashMap<String, String> data = new HashMap<String, String>();
        String id = Names.makeName((NamedDocumentable)proxy);
        int i = 0;
        for (MonitorPool remote : proxy.getRemote()) {
            data.put("remote.queries." + i, this.makeUri(this.app, (NamedDocumentable)remote));
            ++i;
        }
        i = 0;
        for (MonitorPool local : proxy.getLocal()) {
            data.put("local.queries." + i, Names.makeName((NamedDocumentable)local));
            ++i;
        }
        this.addData("org.eclipse.scada.ae.server.monitor.proxy", id, data);
    }

    private String makeUri(MasterServer from, NamedDocumentable remote) {
        MasterServer to = (MasterServer)Locator.findApplication((EObject)remote, MasterServer.class);
        if (to == null) {
            throw new IllegalStateException(String.format("No master server found for pool %s", remote.getName()));
        }
        AlarmsEventsConnection connection = (AlarmsEventsConnection)Locator.findPossibleConnection((EquinoxApplication)from, (EquinoxApplication)to, AlarmsEventsConnection.class);
        return String.valueOf(connection.getName()) + "#" + Names.makeName((NamedDocumentable)remote);
    }
}

