/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.lib.Nodes;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.configuration.world.osgi.profile.SubProfile;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;

public class P2ProfileProcessor {
    private final EquinoxApplication app;

    public P2ProfileProcessor(EquinoxApplication app) {
        this.app = app;
    }

    public void process(File output, IProgressMonitor monitor) throws Exception {
        this.processProfile(output);
    }

    private void processProfile(File output) throws IOException {
        Profile profile = P2ProfileProcessor.makeProfile(this.app);
        File profileFile = new File(output, String.valueOf(this.app.getName()) + ".profile.xml");
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)profileFile.toString()));
        r.getContents().add((Object)EcoreUtil.copy((EObject)profile));
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        r.save(options);
    }

    public static Profile makeProfile(EquinoxApplication app) {
        Profile profile = P2ProfileProcessor.flatten((Profile)EcoreUtil.copy((EObject)app.getProfile()));
        if (profile == null) {
            throw new IllegalStateException("Application implemenation did not return a profile");
        }
        if (app.getCustomizationProfile() != null) {
            P2ProfileProcessor.mergeIntoProfile(P2ProfileProcessor.flatten((Profile)EcoreUtil.copy((EObject)app.getCustomizationProfile())), profile);
        }
        profile.setName(String.format("Custom profile for %s on node %s", app.getName(), Nodes.fromApp((Application)app).getHostName()));
        profile.setDescription(null);
        P2ProfileProcessor.clearNulls(profile);
        return profile;
    }

    protected static void clearNulls(Profile profile) {
        Iterator i = profile.getProperty().iterator();
        while (i.hasNext()) {
            SystemProperty prop = (SystemProperty)i.next();
            if (prop.getValue() != null) continue;
            i.remove();
        }
    }

    public static Profile flatten(Profile profile) {
        P2ProfileProcessor.flatten(profile, (EList<Profile>)profile.getIncludes());
        profile.getIncludes().clear();
        return profile;
    }

    static void flatten(Profile profile, EList<Profile> includes) {
        for (Profile include : includes) {
            P2ProfileProcessor.mergeIntoProfile(include, profile);
            P2ProfileProcessor.flatten(profile, (EList<Profile>)include.getIncludes());
        }
    }

    static void mergeIntoProfile(Profile source, Profile target) {
        target.getInstallationUnits().addAll((Collection)source.getInstallationUnits());
        target.getJvmArguments().addAll((Collection)source.getJvmArguments());
        target.getArguments().addAll((Collection)source.getArguments());
        target.getNotes().addAll((Collection)source.getNotes());
        target.getSetbsl().addAll(EcoreUtil.copyAll((Collection)source.getSetbsl()));
        target.getStart().addAll(EcoreUtil.copyAll((Collection)source.getStart()));
        target.getProperty().addAll(EcoreUtil.copyAll((Collection)source.getProperty()));
        for (SubProfile subProfile : source.getProfile()) {
            P2ProfileProcessor.mergeSubProfile(subProfile, P2ProfileProcessor.findTargetSubProfile(subProfile.getName(), target));
        }
    }

    static void mergeSubProfile(SubProfile source, SubProfile target) {
        target.getProperty().addAll((Collection)target.getProperty());
    }

    static SubProfile findTargetSubProfile(String name, Profile target) {
        SubProfile sub2;
        for (SubProfile sub2 : target.getProfile()) {
            if (!sub2.getName().equals(name)) continue;
            return sub2;
        }
        sub2 = ProfileFactory.eINSTANCE.createSubProfile();
        sub2.setName(name);
        target.getProfile().add((Object)sub2);
        return sub2;
    }
}

