/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ProxyItem;
import org.eclipse.scada.utils.str.StringHelper;

public class ProxyItemGenerator
extends ItemGenerator {
    private final ProxyItem item;

    public ProxyItemGenerator(ProxyItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    public void generate() {
        super.generate();
        this.addProxySource(this.makeSourceId(), this.makeSources(this.item));
    }

    private Collection<String> makeSources(ProxyItem item) {
        ArrayList<String> result = new ArrayList<String>(item.getItems().size());
        for (Item refItem : item.getItems()) {
            result.add(Items.makeMasterId(refItem));
        }
        Collections.sort(result);
        return result;
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("proxy");
    }

    private void addProxySource(String id, Collection<String> sources) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sources", StringHelper.join(sources, (String)", "));
        this.addData("da.datasource.proxy", id, data);
    }
}

