/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.lib.oscar.item;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.scada.configuration.world.lib.oscar.Configurations;
import org.eclipse.scada.configuration.world.lib.oscar.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.lib.oscar.OscarContext;
import org.eclipse.scada.configuration.world.lib.oscar.item.ItemGenerator;
import org.eclipse.scada.configuration.world.lib.oscar.item.Items;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.SummaryGroup;
import org.eclipse.scada.configuration.world.osgi.SummaryItem;
import org.eclipse.scada.utils.str.StringHelper;

public class SummaryItemGenerator
extends ItemGenerator {
    private final SummaryItem item;

    public SummaryItemGenerator(SummaryItem item, OscarContext ctx, MasterHandlerPriorities priorities) {
        super((Item)item, ctx, priorities);
        this.item = item;
    }

    @Override
    protected String makeSourceId() {
        return this.makeId("sum");
    }

    @Override
    public void generate() {
        super.generate();
        this.process(this.item.getGroup());
    }

    public void process(SummaryGroup summaryGroup) {
        List<String> sources = this.makeSources((List<Item>)summaryGroup.getItems());
        List<String> subSources = this.makeGroups((List<Item>)summaryGroup.getItems());
        this.addSum(this.makeSourceId(), sources, subSources, Configurations.groupsSum);
    }

    private List<String> makeGroups(List<Item> items) {
        LinkedList<String> result = new LinkedList<String>();
        for (Item item : items) {
            if (!(item instanceof SummaryItem)) continue;
            result.add(Items.makeMasterId(item));
        }
        return result;
    }

    private List<String> makeSources(List<Item> items) {
        LinkedList<String> result = new LinkedList<String>();
        for (Item item : items) {
            if (item instanceof SummaryItem) continue;
            result.add(Items.makeMasterId(item));
        }
        return result;
    }

    private void addSum(String id, List<String> sources, List<String> subSources, Set<String> groups) {
        HashMap<String, String> data = new HashMap<String, String>();
        Collections.sort(sources);
        Collections.sort(subSources);
        int i = 0;
        for (String item : sources) {
            data.put("datasource." + i, item);
            ++i;
        }
        i = 0;
        for (String item : subSources) {
            data.put("subDatasource." + i, item);
            ++i;
        }
        data.put("groups", StringHelper.join(groups, (String)","));
        this.addData("org.eclipse.scada.da.datasource.sum", id, data);
    }
}

