/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.deployment.impl;

import java.util.Date;
import java.util.UUID;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.world.deployment.Architecture;
import org.eclipse.scada.configuration.world.deployment.Author;
import org.eclipse.scada.configuration.world.deployment.ChangeEntry;
import org.eclipse.scada.configuration.world.deployment.DebianDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.DeploymentFactory;
import org.eclipse.scada.configuration.world.deployment.DeploymentInformation;
import org.eclipse.scada.configuration.world.deployment.DeploymentPackage;
import org.eclipse.scada.configuration.world.deployment.ExpressionNodeMappingEntry;
import org.eclipse.scada.configuration.world.deployment.FallbackNodeMappingMode;
import org.eclipse.scada.configuration.world.deployment.MsiDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.NodeMappings;
import org.eclipse.scada.configuration.world.deployment.P2Platform;
import org.eclipse.scada.configuration.world.deployment.RedhatDeploymentMechanism;
import org.eclipse.scada.configuration.world.deployment.SimpleNodeMappingEntry;
import org.eclipse.scada.configuration.world.deployment.impl.AuthorImpl;
import org.eclipse.scada.configuration.world.deployment.impl.ChangeEntryImpl;
import org.eclipse.scada.configuration.world.deployment.impl.DebianDeploymentMechanismImpl;
import org.eclipse.scada.configuration.world.deployment.impl.DeploymentInformationImpl;
import org.eclipse.scada.configuration.world.deployment.impl.ExpressionNodeMappingEntryImpl;
import org.eclipse.scada.configuration.world.deployment.impl.MsiDeploymentMechanismImpl;
import org.eclipse.scada.configuration.world.deployment.impl.NodeMappingsImpl;
import org.eclipse.scada.configuration.world.deployment.impl.P2PlatformImpl;
import org.eclipse.scada.configuration.world.deployment.impl.RedhatDeploymentMechanismImpl;
import org.eclipse.scada.configuration.world.deployment.impl.SimpleNodeMappingEntryImpl;

public class DeploymentFactoryImpl
extends EFactoryImpl
implements DeploymentFactory {
    public static DeploymentFactory init() {
        try {
            DeploymentFactory theDeploymentFactory = (DeploymentFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/World/Deployment");
            if (theDeploymentFactory != null) {
                return theDeploymentFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DeploymentFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createDebianDeploymentMechanism();
            }
            case 2: {
                return this.createAuthor();
            }
            case 3: {
                return this.createRedhatDeploymentMechanism();
            }
            case 4: {
                return this.createDeploymentInformation();
            }
            case 6: {
                return this.createChangeEntry();
            }
            case 7: {
                return this.createNodeMappings();
            }
            case 8: {
                return this.createExpressionNodeMappingEntry();
            }
            case 10: {
                return this.createSimpleNodeMappingEntry();
            }
            case 11: {
                return this.createMsiDeploymentMechanism();
            }
            case 12: {
                return this.createP2Platform();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.createFallbackNodeMappingModeFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createArchitectureFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 13: {
                return this.convertFallbackNodeMappingModeToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertArchitectureToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public DebianDeploymentMechanism createDebianDeploymentMechanism() {
        DebianDeploymentMechanismImpl debianDeploymentMechanism = new DebianDeploymentMechanismImpl();
        return debianDeploymentMechanism;
    }

    @Override
    public Author createAuthor() {
        AuthorImpl author = new AuthorImpl();
        return author;
    }

    @Override
    public RedhatDeploymentMechanism createRedhatDeploymentMechanism() {
        RedhatDeploymentMechanismImpl redhatDeploymentMechanism = new RedhatDeploymentMechanismImpl();
        return redhatDeploymentMechanism;
    }

    @Override
    public DeploymentInformation createDeploymentInformation() {
        DeploymentInformationImpl deploymentInformation = new DeploymentInformationImpl();
        return deploymentInformation;
    }

    @Override
    public ChangeEntry createChangeEntry() {
        ChangeEntryImpl changeEntry = new ChangeEntryImpl();
        changeEntry.setDate(new Date());
        return changeEntry;
    }

    @Override
    public NodeMappings createNodeMappings() {
        NodeMappingsImpl nodeMappings = new NodeMappingsImpl();
        return nodeMappings;
    }

    @Override
    public ExpressionNodeMappingEntry createExpressionNodeMappingEntry() {
        ExpressionNodeMappingEntryImpl expressionNodeMappingEntry = new ExpressionNodeMappingEntryImpl();
        return expressionNodeMappingEntry;
    }

    @Override
    public SimpleNodeMappingEntry createSimpleNodeMappingEntry() {
        SimpleNodeMappingEntryImpl simpleNodeMappingEntry = new SimpleNodeMappingEntryImpl();
        return simpleNodeMappingEntry;
    }

    @Override
    public MsiDeploymentMechanism createMsiDeploymentMechanism() {
        MsiDeploymentMechanismImpl msiDeploymentMechanism = new MsiDeploymentMechanismImpl();
        msiDeploymentMechanism.setUpgradeCode(UUID.randomUUID().toString());
        return msiDeploymentMechanism;
    }

    @Override
    public P2Platform createP2Platform() {
        P2PlatformImpl p2Platform = new P2PlatformImpl();
        return p2Platform;
    }

    public FallbackNodeMappingMode createFallbackNodeMappingModeFromString(EDataType eDataType, String initialValue) {
        FallbackNodeMappingMode result = FallbackNodeMappingMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFallbackNodeMappingModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Architecture createArchitectureFromString(EDataType eDataType, String initialValue) {
        Architecture result = Architecture.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertArchitectureToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DeploymentPackage getDeploymentPackage() {
        return (DeploymentPackage)this.getEPackage();
    }

    @Deprecated
    public static DeploymentPackage getPackage() {
        return DeploymentPackage.eINSTANCE;
    }
}

