/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.impl;

import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.ExecDriver;
import org.eclipse.scada.configuration.world.ExternalNode;
import org.eclipse.scada.configuration.world.HandlerPriorityRule;
import org.eclipse.scada.configuration.world.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.Options;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.UsernamePasswordCredentials;
import org.eclipse.scada.configuration.world.World;
import org.eclipse.scada.configuration.world.WorldFactory;
import org.eclipse.scada.configuration.world.WorldPackage;
import org.eclipse.scada.configuration.world.impl.ApplicationNodeImpl;
import org.eclipse.scada.configuration.world.impl.EndpointImpl;
import org.eclipse.scada.configuration.world.impl.ExecDriverImpl;
import org.eclipse.scada.configuration.world.impl.ExternalNodeImpl;
import org.eclipse.scada.configuration.world.impl.HandlerPriorityRuleImpl;
import org.eclipse.scada.configuration.world.impl.MasterHandlerPrioritiesImpl;
import org.eclipse.scada.configuration.world.impl.OptionsImpl;
import org.eclipse.scada.configuration.world.impl.PasswordCredentialsImpl;
import org.eclipse.scada.configuration.world.impl.UsernamePasswordCredentialsImpl;
import org.eclipse.scada.configuration.world.impl.WorldImpl;

public class WorldFactoryImpl
extends EFactoryImpl
implements WorldFactory {
    public static WorldFactory init() {
        try {
            WorldFactory theWorldFactory = (WorldFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/World");
            if (theWorldFactory != null) {
                return theWorldFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new WorldFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createWorld();
            }
            case 2: {
                return this.createApplicationNode();
            }
            case 6: {
                return this.createEndpoint();
            }
            case 7: {
                return this.createExecDriver();
            }
            case 9: {
                return this.createHandlerPriorityRule();
            }
            case 10: {
                return this.createMasterHandlerPriorities();
            }
            case 11: {
                return this.createOptions();
            }
            case 12: {
                return this.createUsernamePasswordCredentials();
            }
            case 13: {
                return this.createPasswordCredentials();
            }
            case 15: {
                return this.createExternalNode();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.createPatternFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 18: {
                return this.convertPatternToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public World createWorld() {
        WorldImpl world = new WorldImpl();
        return world;
    }

    @Override
    public ApplicationNode createApplicationNode() {
        ApplicationNodeImpl applicationNode = new ApplicationNodeImpl();
        return applicationNode;
    }

    @Override
    public Endpoint createEndpoint() {
        EndpointImpl endpoint = new EndpointImpl();
        return endpoint;
    }

    @Override
    public ExecDriver createExecDriver() {
        ExecDriverImpl execDriver = new ExecDriverImpl();
        return execDriver;
    }

    @Override
    public HandlerPriorityRule createHandlerPriorityRule() {
        HandlerPriorityRuleImpl handlerPriorityRule = new HandlerPriorityRuleImpl();
        return handlerPriorityRule;
    }

    @Override
    public MasterHandlerPriorities createMasterHandlerPriorities() {
        MasterHandlerPrioritiesImpl masterHandlerPriorities = new MasterHandlerPrioritiesImpl();
        return masterHandlerPriorities;
    }

    @Override
    public Options createOptions() {
        OptionsImpl options = new OptionsImpl();
        return options;
    }

    @Override
    public UsernamePasswordCredentials createUsernamePasswordCredentials() {
        UsernamePasswordCredentialsImpl usernamePasswordCredentials = new UsernamePasswordCredentialsImpl();
        return usernamePasswordCredentials;
    }

    @Override
    public PasswordCredentials createPasswordCredentials() {
        PasswordCredentialsImpl passwordCredentials = new PasswordCredentialsImpl();
        return passwordCredentials;
    }

    @Override
    public ExternalNode createExternalNode() {
        ExternalNodeImpl externalNode = new ExternalNodeImpl();
        return externalNode;
    }

    public Pattern createPatternFromString(EDataType eDataType, String initialValue) {
        return Pattern.compile(initialValue);
    }

    public String convertPatternToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public WorldPackage getWorldPackage() {
        return (WorldPackage)this.getEPackage();
    }

    @Deprecated
    public static WorldPackage getPackage() {
        return WorldPackage.eINSTANCE;
    }
}

