/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Persistence implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    LAZY(1, "LAZY", "LAZY"),
    REQUIRED(2, "REQUIRED", "REQUIRED");

    public static final int NONE_VALUE = 0;
    public static final int LAZY_VALUE = 1;
    public static final int REQUIRED_VALUE = 2;
    private static final Persistence[] VALUES_ARRAY;
    public static final List<Persistence> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Persistence[]{NONE, LAZY, REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Persistence get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Persistence result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Persistence getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Persistence result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Persistence get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return LAZY;
            }
            case 2: {
                return REQUIRED;
            }
        }
        return null;
    }

    private Persistence(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

