/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.common;

import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.client.common.ClientBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionHandler
implements IoHandler {
    private static final Logger logger = LoggerFactory.getLogger(ClientConnectionHandler.class);
    protected final ClientBaseConnection connection;

    public ClientConnectionHandler(ClientBaseConnection connection) {
        this.connection = connection;
    }

    public void exceptionCaught(IoSession session, Throwable error) throws Exception {
        logger.info("exceptionCaught - session: " + session, error);
        this.connection.performClosed(session, error);
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        this.connection.messageReceived(session, message);
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        this.connection.performClosed(session, null);
    }

    public void sessionIdle(IoSession session, IdleStatus idleState) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
        this.connection.performOpened(session);
    }

    public void sessionCreated(IoSession session) throws Exception {
    }
}

