/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.net;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.core.net.ConnectionHelper;
import org.eclipse.scada.net.base.PingService;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.mina.IoSessionSender;
import org.eclipse.scada.net.mina.MessageSender;
import org.eclipse.scada.net.mina.Messenger;
import org.eclipse.scada.net.mina.SocketImpl;
import org.eclipse.scada.sec.callback.CallbackFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.eclipse.scada.utils.stats.StatisticsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionBase
implements Connection,
IoHandler,
StatisticsProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionBase.class);
    private static final Object STATS_PINGS_SENT = new Object();
    private static final Object STATS_SESSION_BYTES_READ = new Object();
    private static final Object STATS_SESSION_BYTES_WRITTEN = new Object();
    private static final Object STATS_CALLS_CONNECT = new Object();
    private static final Object STATS_CALLS_DISCONNECT = new Object();
    private static final Object STATS_NUMERIC_STATE = new Object();
    private final Set<ConnectionStateListener> connectionStateListeners = new CopyOnWriteArraySet<ConnectionStateListener>();
    private volatile ConnectionState connectionState = ConnectionState.CLOSED;
    private static final int DEFAULT_TIMEOUT = 10000;
    protected volatile IoSession session;
    protected final Messenger messenger;
    private final ConnectionInformation connectionInformation;
    private final IoConnector connector;
    private final PingService pingService;
    private ConnectFuture connectingFuture;
    private final ExecutorService lookupExecutor;
    private SocketAddress remoteAddress;
    private volatile Map<String, String> properties;
    protected final StatisticsImpl statistics = new StatisticsImpl();

    public ConnectionBase(ConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
        this.lookupExecutor = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("ConnectionBaseExecutor/" + connectionInformation.toMaskedString()));
        this.messenger = new Messenger((long)this.getMessageTimeout(), this.statistics);
        this.pingService = new PingService(this.messenger);
        this.connector = this.createConnector();
        this.statistics.setLabel(STATS_PINGS_SENT, "Pings sent");
        this.statistics.setLabel(STATS_SESSION_BYTES_READ, "Bytes read in session");
        this.statistics.setLabel(STATS_SESSION_BYTES_WRITTEN, "Bytes written in session");
        this.statistics.setLabel(STATS_CALLS_CONNECT, "Calls to connect");
        this.statistics.setLabel(STATS_CALLS_DISCONNECT, "Calls to disconnect");
        this.statistics.setLabel(STATS_NUMERIC_STATE, "Numeric state");
    }

    public void setCallbackFactory(CallbackFactory callbackFactory) {
    }

    protected synchronized void switchState(ConnectionState state, Throwable error, Map<String, String> properties) {
        logger.debug("Requesting state switch {} -> {}", (Object)this.connectionState, (Object)state);
        if (this.connectionState == state) {
            logger.info("We already are in state: {}", (Object)state);
            return;
        }
        switch (this.connectionState) {
            case CLOSED: {
                this.handleSwitchClosed(state);
                break;
            }
            case CONNECTING: {
                this.handleSwitchConnecting(state, error);
                break;
            }
            case CONNECTED: {
                this.handleSwitchConnected(state, error, properties);
                break;
            }
            case BOUND: {
                this.handleSwitchBound(state, error);
                break;
            }
            case CLOSING: {
                this.handleSwitchClosing(state, error);
                break;
            }
            case LOOKUP: {
                this.handleSwitchLookup(state, error);
            }
        }
    }

    private void handleSwitchLookup(ConnectionState state, Throwable error) {
        switch (state) {
            case CONNECTING: {
                this.performConnect();
                break;
            }
            case CLOSED: {
                this.requestClose(error);
                break;
            }
            case CLOSING: {
                this.requestClose(error);
                break;
            }
        }
    }

    private void handleSwitchClosing(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSED: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
        }
    }

    private void handleSwitchBound(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSING: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
            case CLOSED: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
        }
    }

    private void handleSwitchConnected(ConnectionState state, Throwable error, Map<String, String> properties) {
        switch (state) {
            case CLOSING: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
            case CLOSED: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
            case BOUND: {
                this.properties = properties;
                this.setState(ConnectionState.BOUND, error);
                this.onConnectionBound();
                break;
            }
        }
    }

    private void requestClose(Throwable error) {
        logger.debug("Performing close stuff");
        try {
            this.messenger.disconnected();
            if (this.session != null) {
                this.session.close(true);
            }
            this.session = null;
            this.connectingFuture = null;
            this.properties = null;
        }
        finally {
            this.setState(ConnectionState.CLOSED, error);
        }
    }

    private void handleSwitchConnecting(ConnectionState state, Throwable error) {
        switch (state) {
            case CLOSING: {
                this.requestClose(error);
                break;
            }
            case CONNECTED: {
                this.setState(ConnectionState.CONNECTED, null);
                this.onConnectionEstablished();
                break;
            }
            case CLOSED: {
                this.requestClose(error);
                this.onConnectionClosed();
                break;
            }
        }
    }

    private void handleSwitchClosed(ConnectionState state) {
        switch (state) {
            case CONNECTING: {
                if (this.remoteAddress != null) {
                    this.performConnect();
                    break;
                }
                this.performLookup();
                break;
            }
        }
    }

    public void disconnect() {
        this.statistics.changeCurrentValue(STATS_CALLS_DISCONNECT, 1.0);
        this.disconnect(null);
    }

    protected void disconnect(Throwable error) {
        logger.info("Requested disconnect");
        this.switchState(ConnectionState.CLOSING, error, null);
    }

    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    public void addConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.add(connectionStateListener);
    }

    public void removeConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListeners.remove(connectionStateListener);
    }

    public ConnectionState getState() {
        return this.connectionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ConnectionState connectionState, Throwable error) {
        boolean trigger = false;
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (this.connectionState != connectionState) {
                this.statistics.setCurrentValue(STATS_NUMERIC_STATE, (double)connectionState.ordinal());
                this.connectionState = connectionState;
                trigger = true;
            }
        }
        if (trigger) {
            this.notifyStateChange(connectionState, error);
        }
    }

    private void notifyStateChange(ConnectionState connectionState, Throwable error) {
        for (ConnectionStateListener listener : this.connectionStateListeners) {
            try {
                listener.stateChange((Connection)this, connectionState, error);
            }
            catch (Exception e) {
                logger.info("Failed to handle state change", (Throwable)e);
            }
        }
    }

    protected void setupConnector(ConnectionInformation connectionInformation, IoConnector connector) {
        connector.setConnectTimeoutMillis((long)this.getConnectTimeout());
        ConnectionHelper.setupFilterChain((ConnectionInformation)connectionInformation, (DefaultIoFilterChainBuilder)connector.getFilterChain(), (boolean)true);
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void connect(CallbackHandler callbackHandler) {
        this.connect();
    }

    public synchronized void connect() {
        logger.debug("Requesting connect in state {}", (Object)this.connectionState);
        this.statistics.changeCurrentValue(STATS_CALLS_CONNECT, 1.0);
        if (this.connectionState == ConnectionState.CLOSED) {
            this.switchState(ConnectionState.CONNECTING, null, null);
        }
    }

    protected synchronized void performLookup() {
        this.setState(ConnectionState.LOOKUP, null);
        this.lookupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionBase.this.doLookup();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolvedRemoteAddress(SocketAddress address, Throwable e) {
        logger.debug("Completed resolving remote address: {}", (Object)address);
        if (e != null) {
            logger.warn("Failed to resolve: " + address, e);
        }
        if (this.connectionState != ConnectionState.LOOKUP) {
            logger.info("Connection state {} is not LOOKUP", (Object)this.connectionState);
            return;
        }
        ConnectionBase connectionBase = this;
        synchronized (connectionBase) {
            if (this.connectionState != ConnectionState.LOOKUP) {
                logger.info("Connection state {} is not LOOKUP for the second time", (Object)this.connectionState);
                return;
            }
            if (e == null) {
                this.remoteAddress = address;
                this.switchState(ConnectionState.CONNECTING, null, null);
            } else {
                this.switchState(ConnectionState.CLOSED, e, null);
            }
        }
    }

    protected synchronized void performConnect() {
        this.setState(ConnectionState.CONNECTING, null);
        try {
            this.connectingFuture = this.connector.connect(this.remoteAddress);
            this.connectingFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

                public void operationComplete(final ConnectFuture future) {
                    logger.debug("Connect operation complete");
                    try {
                        future.getSession();
                    }
                    catch (Throwable e) {
                        logger.debug("Operation failed", e);
                        ConnectionBase.this.lookupExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                ConnectionBase.this.connectFailed(future, e);
                            }
                        });
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to create future", (Throwable)e);
            this.connectFailed(this.connectingFuture, e);
        }
    }

    protected synchronized void connectFailed(ConnectFuture future, Throwable e) {
        String connection = "";
        if (this.connectionInformation != null) {
            connection = String.valueOf(connection) + " " + this.connectionInformation.toMaskedString();
        }
        logger.info("Connection attempt failed" + connection, e);
        if (future == this.connectingFuture) {
            this.connectingFuture = null;
            this.switchState(ConnectionState.CLOSED, e, null);
        }
    }

    private String getSocketImpl() {
        return (String)this.connectionInformation.getProperties().get("socketImpl");
    }

    private IoConnector createConnector() {
        SocketImpl socketImpl = SocketImpl.fromName((String)this.getSocketImpl());
        IoConnector connector = socketImpl.createConnector();
        connector.setHandler((IoHandler)this);
        this.setupConnector(this.connectionInformation, connector);
        return connector;
    }

    public void cancelConnection() {
        this.session.close(true);
    }

    protected void onConnectionClosed() {
        this.pingService.stop();
        this.properties = null;
    }

    protected void onConnectionEstablished() {
        this.setBound(new Properties());
    }

    public void setBound(Properties properties) {
        logger.debug("Request BOUND state");
        this.pingService.start();
        this.switchState(ConnectionState.BOUND, null, this.convertProperties(properties));
    }

    private Map<String, String> convertProperties(Properties properties) {
        if (properties == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(1);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return result;
    }

    protected void onConnectionBound() {
    }

    public synchronized void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        logger.error(String.format("Connection exception for connection: %s", this.connectionInformation != null ? this.connectionInformation.toMaskedString() : "<null>"), cause);
        if (session == this.session) {
            this.requestClose(cause);
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (session == this.session) {
            this.statistics.setCurrentValue(STATS_SESSION_BYTES_READ, (double)session.getReadBytes());
            if (message instanceof Message) {
                this.messenger.messageReceived((Message)message);
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        this.statistics.setCurrentValue(STATS_SESSION_BYTES_WRITTEN, (double)session.getWrittenBytes());
        this.statistics.setCurrentValue(IoSessionSender.STATS_QUEUED_BYTES, (double)session.getScheduledWriteBytes());
    }

    public synchronized void sessionClosed(IoSession session) throws Exception {
        logger.info("Session closed: {}", (Object)session);
        if (session == this.session) {
            this.switchState(ConnectionState.CLOSED, null, null);
        }
    }

    public synchronized void sessionCreated(IoSession session) throws Exception {
        logger.info("Session created: {}", (Object)session);
        session.getConfig().setReaderIdleTime(this.getPingPeriod() / 1000);
        IoSessionConfig config = session.getConfig();
        if (config instanceof SocketSessionConfig) {
            Integer receiveBuffer;
            Integer sendBuffer = this.getSocketSendBufferSize();
            if (sendBuffer != null) {
                ((SocketSessionConfig)config).setSendBufferSize(sendBuffer.intValue());
            }
            if ((receiveBuffer = this.getSocketReceiveBufferSize()) != null) {
                ((SocketSessionConfig)config).setReceiveBufferSize(receiveBuffer.intValue());
            }
        }
        if (this.session == null) {
            this.session = session;
        } else {
            logger.error("Created a new session with an existing one! (existing: {})", (Object)this.session);
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        logger.debug("Session idle: {} - {}", (Object)status, (Object)session);
        if (session != this.session) {
            return;
        }
        this.pingService.sendPing();
        this.statistics.changeCurrentValue(STATS_PINGS_SENT, 1.0);
    }

    public synchronized void sessionOpened(IoSession session) throws Exception {
        logger.info("Session opened: {}", (Object)session);
        if (session == this.session) {
            this.messenger.connected((MessageSender)new IoSessionSender(session, this.statistics));
            this.switchState(ConnectionState.CONNECTED, null, null);
        }
    }

    public int getConnectTimeout() {
        return this.getIntProperty("connectTimeout", this.getIntProperty("timeout", 10000));
    }

    public int getPingPeriod() {
        return this.getIntProperty("pingPeriod", this.getIntProperty("timeout", 10000) / this.getIntProperty("pingFrequency", 3));
    }

    public Integer getSocketReceiveBufferSize() {
        return this.getIntProperty("socketReceiveBufferSize", Integer.getInteger("org.eclipse.scada.core.client.net.socketReceiveBufferSize", null));
    }

    public Integer getSocketSendBufferSize() {
        return this.getIntProperty("socketSendBufferSize", Integer.getInteger("org.eclipse.scada.core.client.net.socketSendBufferSize", null));
    }

    public int getMessageTimeout() {
        return this.getIntProperty("messageTimeout", this.getIntProperty("timeout", 10000));
    }

    protected Integer getIntProperty(String propertyName, Integer defaultValue) {
        try {
            String timeout = (String)this.connectionInformation.getProperties().get(propertyName);
            int i = Integer.parseInt(timeout);
            if (i <= 0) {
                return defaultValue;
            }
            return i;
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    protected void finalize() throws Throwable {
        logger.info("Finalized");
        this.lookupExecutor.shutdown();
        super.finalize();
    }

    private void doLookup() {
        try {
            SocketImpl socketImpl = SocketImpl.fromName((String)this.getSocketImpl());
            SocketAddress address = socketImpl.doLookup(this.connectionInformation.getTarget(), this.connectionInformation.getSecondaryTarget().intValue());
            this.resolvedRemoteAddress(address, null);
        }
        catch (Throwable e) {
            this.resolvedRemoteAddress(null, e);
        }
    }

    public void dispose() {
        this.disconnect(null);
        this.lookupExecutor.shutdown();
        this.connector.dispose();
    }

    public Map<String, String> getSessionProperties() {
        Map<String, String> properties = this.properties;
        if (properties != null) {
            return Collections.unmodifiableMap(properties);
        }
        return Collections.emptyMap();
    }

    public Collection<StatisticEntry> getStatistics() {
        return this.statistics.getEntries();
    }
}

