/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ConnectionStateListener;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReconnectController
implements ConnectionStateListener {
    private static final Logger logger = LoggerFactory.getLogger(AutoReconnectController.class);
    private static final long DEFAULT_RECONNECT_DELAY = Long.getLong("org.eclipse.scada.core.client.defaultReconnectDelay", 10000L);
    private final Connection connection;
    private boolean connect;
    private final long reconnectDelay;
    private ScheduledExecutorService executor;
    private long lastTimestamp;
    private ConnectionState state;
    private boolean checkScheduled;
    private long lastStateChange;
    private CallbackHandler connectCallbackHandler;
    private ScheduledFuture<?> zombieJob;

    public AutoReconnectController(Connection connection) {
        this(connection, DEFAULT_RECONNECT_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutoReconnectController(Connection connection, long reconnectDelay) {
        this.connection = connection;
        this.reconnectDelay = reconnectDelay;
        if (this.connection == null) {
            throw new IllegalArgumentException("'connection' must not be null");
        }
        if (reconnectDelay <= 0L) {
            reconnectDelay = DEFAULT_RECONNECT_DELAY;
        }
        NamedThreadFactory threadFactory = new NamedThreadFactory("AutoReconnect/" + connection.getConnectionInformation().toMaskedString());
        AutoReconnectController autoReconnectController = this;
        synchronized (autoReconnectController) {
            this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory);
        }
        this.connection.addConnectionStateListener(this);
        if (!Boolean.getBoolean("org.eclipse.scada.core.client.AutoReconnectController.disableZombieMode")) {
            this.zombieJob = this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    AutoReconnectController.this.checkDead();
                }
            }, reconnectDelay, reconnectDelay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkDead() {
        AutoReconnectController autoReconnectController = this;
        synchronized (autoReconnectController) {
            if (this.lastStateChange == 0L) {
                return;
            }
            if (this.state != ConnectionState.CONNECTING) {
                return;
            }
            if (System.currentTimeMillis() - this.lastStateChange < this.reconnectDelay * 3L) {
                return;
            }
        }
        logger.error("Found zombie : {} {}", new Object[]{this.state, this.lastStateChange});
        this.connection.disconnect();
    }

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean disconnect) {
        ScheduledExecutorService executor;
        logger.debug("Disposing - disconnect: {}", (Object)disconnect);
        AutoReconnectController autoReconnectController = this;
        synchronized (autoReconnectController) {
            executor = this.executor;
            if (this.executor != null) {
                if (disconnect) {
                    this.disconnect();
                }
                this.executor = null;
            }
        }
        if (this.zombieJob != null) {
            this.zombieJob.cancel(false);
            this.zombieJob = null;
        }
        if (executor != null) {
            executor.shutdown();
        }
    }

    protected void finalize() throws Throwable {
        logger.debug("Finalized");
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        super.finalize();
    }

    public synchronized void connect() {
        this.connect(null);
    }

    public synchronized void connect(CallbackHandler connectCallbackHandler) {
        this.connectCallbackHandler = connectCallbackHandler;
        logger.debug("Request to connect");
        if (this.connect) {
            return;
        }
        this.connect = true;
        this.lastTimestamp = 0L;
        this.triggerUpdate(this.connection.getState());
    }

    public synchronized void disconnect() {
        logger.debug("Request to disconnect");
        if (!this.connect) {
            return;
        }
        this.connect = false;
        this.lastTimestamp = 0L;
        this.triggerUpdate(this.connection.getState());
    }

    @Override
    public void stateChange(Connection connection, ConnectionState state, Throwable error) {
        logger.info(String.format("State change: %s", new Object[]{state}), error);
        this.triggerUpdate(state);
    }

    private synchronized void triggerUpdate(final ConnectionState state) {
        this.state = state;
        this.lastStateChange = System.currentTimeMillis();
        if (!this.checkScheduled && this.executor != null) {
            this.checkScheduled = true;
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AutoReconnectController.this.performUpdate(state);
                }
            });
        }
    }

    private void performUpdate(ConnectionState state) {
        logger.debug("Performing update: {}", (Object)state);
        long now = System.currentTimeMillis();
        long diff = now - this.lastTimestamp;
        logger.debug(String.format("Last action: %s, diff: %s, delay: %s", this.lastTimestamp, diff, this.reconnectDelay));
        if (diff > this.reconnectDelay) {
            this.performCheckNow();
        } else {
            long delay = this.reconnectDelay - diff;
            logger.info("Delaying next check by {} milliseconds", (Object)delay);
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    AutoReconnectController.this.performCheckNow();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
        this.lastTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCheckNow() {
        boolean connect;
        ConnectionState currentState;
        AutoReconnectController autoReconnectController = this;
        synchronized (autoReconnectController) {
            currentState = this.state;
            connect = this.connect;
            this.checkScheduled = false;
        }
        logger.debug(String.format("Performing state check: %s (request: %s)", new Object[]{currentState, connect}));
        switch (currentState) {
            case CLOSED: {
                if (!connect) break;
                logger.info("Trigger connect");
                this.connection.connect(this.connectCallbackHandler);
                break;
            }
            case LOOKUP: 
            case CONNECTING: 
            case CONNECTED: 
            case BOUND: {
                if (connect) break;
                logger.info("Trigger disconnect");
                this.connection.disconnect();
                break;
            }
            default: {
                logger.info("Do nothing");
            }
        }
    }
}

