/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.subscription;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.subscription.SubscriptionInformation;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionSource;

public class Subscription<T> {
    private final Map<SubscriptionInformation<T>, Object> listeners = new HashMap<SubscriptionInformation<T>, Object>(1);
    private SubscriptionSource<T> source;
    private final T topic;

    public Subscription(T topic) {
        this.topic = topic;
    }

    public synchronized boolean isEmpty() {
        return this.source == null && this.listeners.isEmpty();
    }

    public synchronized boolean isGranted() {
        return this.source == null && !this.listeners.isEmpty();
    }

    public synchronized boolean isSubscribed() {
        return !this.listeners.isEmpty();
    }

    public synchronized void subscribe(SubscriptionListener<T> listener, Object hint) {
        SubscriptionInformation<T> subscriptionInformation = new SubscriptionInformation<T>(listener, hint);
        if (this.listeners.containsKey(subscriptionInformation)) {
            return;
        }
        this.listeners.put(subscriptionInformation, hint);
        if (this.source == null) {
            listener.updateStatus(this.topic, SubscriptionState.GRANTED);
        } else {
            listener.updateStatus(this.topic, SubscriptionState.CONNECTED);
            this.source.addListener(Collections.singleton(subscriptionInformation));
        }
    }

    public synchronized void unsubscribe(SubscriptionListener<T> listener) {
        SubscriptionInformation<T> subscriptionInformation = new SubscriptionInformation<T>(listener, null);
        if (this.listeners.containsKey(subscriptionInformation)) {
            Object hint = this.listeners.remove(subscriptionInformation);
            subscriptionInformation.setHint(hint);
            if (this.source != null) {
                this.source.removeListener(Collections.singleton(subscriptionInformation));
            }
            listener.updateStatus(this.topic, SubscriptionState.DISCONNECTED);
        }
    }

    public synchronized void setSource(SubscriptionSource<T> source) {
        if (this.source == source) {
            return;
        }
        if (this.source != null) {
            this.source.removeListener(this.listeners.keySet());
        }
        Set<SubscriptionInformation<T>> keys = this.listeners.keySet();
        if (source != null) {
            for (SubscriptionInformation<T> information : keys) {
                information.getListener().updateStatus(this.topic, SubscriptionState.CONNECTED);
            }
            if (!keys.isEmpty()) {
                source.addListener(keys);
            }
        } else {
            for (SubscriptionInformation<T> information : keys) {
                information.getListener().updateStatus(this.topic, SubscriptionState.GRANTED);
            }
        }
        this.source = source;
    }
}

