/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection.information.details;

import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.scada.core.client.Connection;
import org.eclipse.scada.core.client.PrivilegeListener;

public class PrivilegeSet
extends WritableSet {
    private final Connection connection;
    private final PrivilegeListener listener = new PrivilegeListener(){

        public void privilegesChanged(Set<String> granted) {
            PrivilegeSet.this.privilegesChanged(granted);
        }
    };

    public PrivilegeSet(Connection connection, Realm realm) {
        super(realm);
        this.connection = connection;
        this.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent event) {
                PrivilegeSet.this.handleDispose();
            }
        });
        connection.addPrivilegeListener(this.listener);
    }

    private void handleDispose() {
        this.connection.removePrivilegeListener(this.listener);
    }

    private void privilegesChanged(final Set<String> granted) {
        if (this.isDisposed()) {
            return;
        }
        this.getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                PrivilegeSet.this.handleChange(granted);
            }
        });
    }

    private void handleChange(Set<String> granted) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.setStale(false);
            if (granted == null) {
                this.clear();
            } else {
                Diffs.computeSetDiff((Set)((Object)this), granted).applyTo((Set)((Object)this));
            }
        }
        finally {
            this.setStale(false);
        }
    }
}

