/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.ui.connection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scada.core.ui.connection.ConnectionDiscoverer;
import org.eclipse.scada.core.ui.connection.Root;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererAdapterFactory;
import org.eclipse.scada.core.ui.connection.data.ConnectionDiscovererBean;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolder;
import org.eclipse.scada.core.ui.connection.data.ConnectionHolderAdapterFactory;
import org.eclipse.scada.core.ui.connection.data.ConnectionManager;
import org.eclipse.scada.core.ui.connection.views.tree.ConnectionTreeManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scada.core.ui.connection";
    public static final String EXTP_CONNECTON_DISCOVERER = "org.eclipse.scada.core.ui.connection.discoverer";
    private static final String ELE_DISCOVERER = "discoverer";
    private static Activator plugin;
    private ObservableSet discoverers;
    private WritableSet treeRoot;
    private final Map<Class<?>, IAdapterFactory> adaperFactories = new HashMap();
    private ConnectionManager connectionManager;
    private ConnectionTreeManager treeRootManager;
    public static final Root ROOT;

    static {
        ROOT = new Root();
    }

    public Activator() {
        this.adaperFactories.put(ConnectionDiscovererBean.class, new ConnectionDiscovererAdapterFactory());
        this.adaperFactories.put(ConnectionHolder.class, new ConnectionHolderAdapterFactory());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.treeRoot = new WritableSet(SWTObservables.getRealm((Display)this.getWorkbench().getDisplay()));
        this.treeRootManager = new ConnectionTreeManager(this.treeRoot);
        this.connectionManager = new ConnectionManager(context);
        for (Map.Entry<Class<?>, IAdapterFactory> entry : this.adaperFactories.entrySet()) {
            Platform.getAdapterManager().registerAdapters(entry.getValue(), entry.getKey());
        }
    }

    public void stop(BundleContext context) throws Exception {
        for (Map.Entry<Class<?>, IAdapterFactory> entry : this.adaperFactories.entrySet()) {
            Platform.getAdapterManager().unregisterAdapters(entry.getValue(), entry.getKey());
        }
        if (this.connectionManager != null) {
            this.connectionManager.dispose();
            this.connectionManager = null;
        }
        this.treeRootManager.dispose();
        this.treeRoot.dispose();
        plugin = null;
        super.stop(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IObservableSet getDiscovererSet() {
        Activator activator = this;
        synchronized (activator) {
            if (this.discoverers == null) {
                this.discoverers = this.createDiscoverers();
            }
            return Observables.proxyObservableSet((IObservableSet)this.discoverers);
        }
    }

    public ObservableSet getTreeRoot() {
        return this.treeRoot;
    }

    private ObservableSet createDiscoverers() {
        WritableSet result = new WritableSet(SWTObservables.getRealm((Display)this.getWorkbench().getDisplay()));
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_CONNECTON_DISCOVERER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ELE_DISCOVERER.equals(ele.getName())) {
                String id = ele.getAttribute("id");
                String name = ele.getAttribute("name");
                if (name == null) {
                    name = id;
                }
                String icon = ele.getAttribute("icon");
                ImageDescriptor imageDescriptor = null;
                if (icon != null) {
                    imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)ele.getContributor().getName(), (String)icon);
                }
                String description = ele.getAttribute("description");
                try {
                    ConnectionDiscovererBean bean = new ConnectionDiscovererBean(id, name, description, imageDescriptor, (ConnectionDiscoverer)ele.createExecutableExtension("class"));
                    result.add((Object)bean);
                }
                catch (CoreException e) {
                    this.getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        return result;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ConnectionManager getDefaultConectionManager() {
        return Activator.getDefault().getConnectionManager();
    }
}

