/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.client.sfp.strategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.client.ItemUpdateListener;
import org.eclipse.scada.da.client.sfp.ConnectionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataManager {
    private static final Logger logger = LoggerFactory.getLogger(DataManager.class);
    private final ConnectionHandler connectionHandler;
    private final Map<String, ItemUpdateListener> itemListeners = new HashMap<String, ItemUpdateListener>();
    private final Map<Integer, DataItemValue> cache = new HashMap<Integer, DataItemValue>();
    private final Map<Integer, String> registerMap = new HashMap<Integer, String>();
    private final Map<String, Integer> itemIdMap = new HashMap<String, Integer>();
    private final Set<String> activeSet = new HashSet<String>();

    public DataManager(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Integer findRegister(String itemId) {
        return this.itemIdMap.get(itemId);
    }

    public void updateData(int registerNumber, final DataItemValue value) {
        logger.debug("Update data - registerNumer: {}, value: {}", (Object)registerNumber, (Object)value);
        final DataItemValue oldValue = this.cache.get(registerNumber);
        this.cache.put(registerNumber, value);
        String itemId = this.registerMap.get(registerNumber);
        final ItemUpdateListener listener = this.itemListeners.get(itemId);
        logger.debug("Listener: {}, active: {}", (Object)listener, (Object)this.activeSet.contains(itemId));
        if (listener == null || !this.activeSet.contains(itemId)) {
            return;
        }
        if (oldValue != null) {
            final Variant valueChange = !oldValue.getValue().equals((Object)value.getValue()) ? value.getValue() : null;
            final Map attributesChange = AttributesHelper.diff((Map)oldValue.getAttributes(), (Map)value.getAttributes());
            this.execute(new Runnable(){

                @Override
                public void run() {
                    if (oldValue.getSubscriptionState() != SubscriptionState.CONNECTED) {
                        listener.notifySubscriptionChange(SubscriptionState.CONNECTED, null);
                    }
                    listener.notifyDataChange(valueChange, attributesChange.isEmpty() ? null : attributesChange, false);
                }
            });
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(SubscriptionState.CONNECTED, null);
                    listener.notifyDataChange(value.getValue(), value.getAttributes(), false);
                }
            });
        }
    }

    public void removeRegister(int registerNumber) {
        DataItemValue oldValue;
        String oldItemId = this.registerMap.remove(registerNumber);
        if (oldItemId != null) {
            this.itemIdMap.remove(oldItemId);
        }
        if ((oldValue = this.cache.remove(registerNumber)) == null) {
            return;
        }
        final ItemUpdateListener listener = this.itemListeners.get(oldItemId);
        if (listener == null) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                listener.notifySubscriptionChange(SubscriptionState.GRANTED, null);
            }
        });
    }

    public void dispose() {
        for (final ItemUpdateListener listener : this.itemListeners.values()) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(SubscriptionState.DISCONNECTED, null);
                }
            });
        }
        this.itemListeners.clear();
    }

    public void setItemUpateListener(String itemId, ItemUpdateListener listener) {
        if (listener != null) {
            this.itemListeners.put(itemId, listener);
        } else {
            this.itemListeners.remove(itemId);
        }
    }

    public void setAllItemListeners(Map<String, ItemUpdateListener> itemListeners) {
        for (Map.Entry<String, ItemUpdateListener> entry : itemListeners.entrySet()) {
            this.setItemUpateListener(entry.getKey(), entry.getValue());
        }
    }

    protected void execute(Runnable command) {
        this.connectionHandler.getExecutor().execute(command);
    }

    public void addMapping(int register, String itemId, String unit) {
        logger.debug("Adding mapping - register: {}, itemId: {}", (Object)register, (Object)itemId);
        this.registerMap.put(register, itemId);
        this.itemIdMap.put(itemId, register);
        final DataItemValue value = this.cache.get(register);
        final ItemUpdateListener listener = this.itemListeners.get(itemId);
        if (listener != null && value != null && this.activeSet.contains(itemId)) {
            logger.debug("Sending last known state");
            this.execute(new Runnable(){

                @Override
                public void run() {
                    listener.notifySubscriptionChange(SubscriptionState.CONNECTED, null);
                    listener.notifyDataChange(value.getValue(), value.getAttributes(), true);
                }
            });
        }
    }

    public void removeMapping(String itemId) {
        Integer registerNumber = this.itemIdMap.remove(itemId);
        if (registerNumber != null) {
            this.registerMap.remove(registerNumber);
        }
        this.fireSubscriptionChange(itemId, SubscriptionState.GRANTED);
    }

    protected void fireSubscriptionChange(String itemId, final SubscriptionState state) {
        final ItemUpdateListener listener = this.itemListeners.get(itemId);
        if (listener == null || !this.activeSet.contains(itemId)) {
            return;
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                listener.notifySubscriptionChange(state, null);
            }
        });
    }

    public void subscribeItem(String itemId) {
        logger.debug("Subscribe item: {}", (Object)itemId);
        this.activeSet.add(itemId);
        Integer registerNumber = this.itemIdMap.get(itemId);
        final DataItemValue value = registerNumber != null ? this.cache.get(registerNumber) : null;
        final ItemUpdateListener listener = this.itemListeners.get(itemId);
        if (listener == null) {
            return;
        }
        final ConnectionState state = this.connectionHandler.getConnectionState();
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (state != ConnectionState.BOUND) {
                    listener.notifySubscriptionChange(SubscriptionState.DISCONNECTED, null);
                } else if (value != null) {
                    listener.notifySubscriptionChange(SubscriptionState.CONNECTED, null);
                    listener.notifyDataChange(value.getValue(), value.getAttributes(), true);
                } else {
                    listener.notifySubscriptionChange(SubscriptionState.GRANTED, null);
                }
            }
        });
    }

    public void unsubscribeItem(String itemId) {
        this.fireSubscriptionChange(itemId, SubscriptionState.DISCONNECTED);
        this.activeSet.remove(itemId);
    }
}

