/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.data;

import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scada.da.datasource.data.DataItemValueLight;

public class DataItemValueRange {
    private DataItemValueLight firstValue = DataItemValueLight.DISCONNECTED;
    private final SortedSet<DataItemValueLight> values = new TreeSet<DataItemValueLight>(DataItemValueLight.timestampComparator);
    private final long rangeOrAlignment;
    private final TimeUnit absolute;
    private long oldestPossibleTimestamp;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public DataItemValueRange(long range) {
        this.rangeOrAlignment = range;
        this.absolute = null;
        this.oldestPossibleTimestamp = this.calculateOldestTimestamp(System.currentTimeMillis());
    }

    public DataItemValueRange(TimeUnit absolute, long alignment) {
        this.rangeOrAlignment = alignment;
        if (absolute == TimeUnit.NANOSECONDS) {
            throw new IllegalArgumentException(String.format("%s is not allowed, %s works only with at least milliseconds resolution", new Object[]{absolute, this.getClass().getName()}));
        }
        this.absolute = absolute;
        this.oldestPossibleTimestamp = this.calculateOldestTimestamp(System.currentTimeMillis());
    }

    private long calculateOldestTimestamp(long timestamp) {
        if (this.absolute != null) {
            return timestamp - timestamp % TimeUnit.MILLISECONDS.convert(this.rangeOrAlignment, this.absolute);
        }
        return timestamp - this.rangeOrAlignment;
    }

    public int add(DataItemValueLight dataItemValue) {
        this.lock.writeLock().lock();
        try {
            if (this.firstValue == DataItemValueLight.DISCONNECTED) {
                this.firstValue = dataItemValue;
            }
            this.values.add(dataItemValue);
            this.checkRangeInternal(this.calculateOldestTimestamp(System.currentTimeMillis()));
            int n = this.values.size();
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int checkRange() {
        this.lock.writeLock().lock();
        try {
            int n = this.checkRangeInternal(this.calculateOldestTimestamp(System.currentTimeMillis()));
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public DataItemValueRangeInfo getInfo() {
        this.lock.readLock().lock();
        try {
            DataItemValueRangeInfo dataItemValueRangeInfo = new DataItemValueRangeInfo(this.oldestPossibleTimestamp, this.values.size(), this.firstValue);
            return dataItemValueRangeInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DataItemValueRangeState getState() {
        this.lock.readLock().lock();
        try {
            DataItemValueRangeState dataItemValueRangeState = new DataItemValueRangeState(this.oldestPossibleTimestamp, this.values.size(), this.firstValue, new TreeSet<DataItemValueLight>(this.values));
            return dataItemValueRangeState;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public long getRange() {
        return this.rangeOrAlignment;
    }

    public TimeUnit getAbsolute() {
        return this.absolute;
    }

    private int checkRangeInternal(long oldestPossibleTimestamp) {
        TreeSet<DataItemValueLight> toRemove = new TreeSet<DataItemValueLight>();
        for (DataItemValueLight dataItemValueLight : this.values) {
            if (dataItemValueLight.getTimestamp() >= oldestPossibleTimestamp) continue;
            toRemove.add(dataItemValueLight);
        }
        if (!toRemove.isEmpty()) {
            this.firstValue = (DataItemValueLight)toRemove.last();
            this.values.removeAll(toRemove);
        }
        this.oldestPossibleTimestamp = oldestPossibleTimestamp;
        return this.values.size();
    }

    public class DataItemValueRangeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long oldestPossibleTimestamp;
        private final int size;
        private final DataItemValueLight firstValue;

        public DataItemValueRangeInfo(long oldestPossibleTimestamp, int size, DataItemValueLight firstValue) {
            this.oldestPossibleTimestamp = oldestPossibleTimestamp;
            this.size = size;
            this.firstValue = firstValue;
        }

        public long getOldestPossibleTimestamp() {
            return this.oldestPossibleTimestamp;
        }

        public int getSize() {
            return this.size;
        }

        public DataItemValueLight getFirstValue() {
            return this.firstValue;
        }

        public String toString() {
            return "firstValue=" + this.firstValue + ", size=" + this.size + ", oldestPossibleTimestamp=" + String.format("[%1$tF %1$tT,%1$tL]", this.oldestPossibleTimestamp);
        }
    }

    public class DataItemValueRangeState
    extends DataItemValueRangeInfo {
        private static final long serialVersionUID = 1L;
        private final SortedSet<DataItemValueLight> values;

        public DataItemValueRangeState(long oldestPossibleTimestamp, int size, DataItemValueLight firstValue, SortedSet<DataItemValueLight> values) {
            super(oldestPossibleTimestamp, size, firstValue);
            this.values = values;
        }

        public SortedSet<DataItemValueLight> getValues() {
            return this.values;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", values=" + this.values;
        }
    }
}

