/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.master.analyzer;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.da.master.analyzer.ConnectionAnalyzer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAnalyzerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionAnalyzerFactory.class);
    private final ServiceTracker<ConnectionService, ConnectionService> connectionTracker;
    private final Map<ConnectionService, ConnectionAnalyzer> serviceMap = new HashMap<ConnectionService, ConnectionAnalyzer>();
    private final BundleContext context;
    private final ScheduledExecutorService executor;

    public ConnectionAnalyzerFactory(ScheduledExecutorService executor, final BundleContext context) {
        this.executor = executor;
        this.context = context;
        this.connectionTracker = new ServiceTracker(context, ConnectionService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConnectionService, ConnectionService>(){

            public void removedService(ServiceReference<ConnectionService> reference, ConnectionService service) {
                ConnectionAnalyzerFactory.this.removeService(service);
            }

            public void modifiedService(ServiceReference<ConnectionService> reference, ConnectionService service) {
            }

            public ConnectionService addingService(ServiceReference<ConnectionService> reference) {
                try {
                    logger.debug("Found new service: {}", reference);
                    ConnectionService service = (ConnectionService)context.getService(reference);
                    ConnectionAnalyzerFactory.this.addService(reference, service);
                    return service;
                }
                catch (Throwable e) {
                    logger.warn("Failed to add service", e);
                    context.ungetService(reference);
                    return null;
                }
            }
        });
        this.connectionTracker.open();
    }

    public void dispose() {
        this.connectionTracker.close();
    }

    protected void addService(ServiceReference<ConnectionService> reference, ConnectionService service) {
        logger.info("Adding service: {} -> {}", new Object[]{reference, service});
        ConnectionAnalyzer analyzer = new ConnectionAnalyzer(this.executor, this.context, reference, service);
        this.serviceMap.put(service, analyzer);
    }

    protected void removeService(ConnectionService service) {
        logger.info("Removing service: {}", (Object)service);
        ConnectionAnalyzer analyzer = this.serviceMap.remove(service);
        if (analyzer != null) {
            analyzer.dispose();
        }
    }
}

